<?php
namespace boru\dhdb\core;

class Error {
    public $query;
    public $params;
    public $interpolated;
    public $message;
    public $code;
    public $trace;

    public function __construct($query="",$params=[],$interpolated="",$exception=null) {
        if(!is_null($exception) && $exception instanceof \Exception) {
            $this->setMessage($exception->getMessage());
            $this->setTrace($exception->getTrace());
            $this->setCode($exception->getCode());
        }
        $this->setQuery($query);
        $this->setParams($params);
        $this->setInterpolated($interpolated);
    }
    public function toArray() {
        $array["query"] = $this->query;
        if(!empty($this->params)) {
            $array["params"] = $this->params;
            $array["interpolated"] = $this->interpolated;
        }
        $array["message"] = $this->message;
        $array["code"] = $this->code;
        $array["trace"] = $this->trace;
        return $array;
    }

    /**
     * Get the value of message
     */ 
    public function getMessage()
    {
        return $this->message;
    }

    /**
     * Set the value of message
     *
     * @return  self
     */ 
    public function setMessage($message)
    {
        $this->message = $message;

        return $this;
    }

    /**
     * Get the value of query
     */ 
    public function getQuery()
    {
        return $this->query;
    }

    /**
     * Set the value of query
     *
     * @return  self
     */ 
    public function setQuery($query)
    {
        $this->query = $query;

        return $this;
    }

    /**
     * Get the value of params
     */ 
    public function getParams()
    {
        return $this->params;
    }

    /**
     * Set the value of params
     *
     * @return  self
     */ 
    public function setParams($params)
    {
        $this->params = $params;

        return $this;
    }

    /**
     * Get the value of trace
     */ 
    public function getTrace()
    {
        return $this->trace;
    }

    /**
     * Set the value of trace
     *
     * @return  self
     */ 
    public function setTrace($trace)
    {
        $this->trace = $trace;

        return $this;
    }

    /**
     * Get the value of interpolated
     *
     * @return  mixed
     */
    public function getInterpolated() {
        return $this->interpolated;
    }

    /**
     * Set the value of interpolated
     *
     * @param   mixed  $interpolated  
     * @return  self
     */
    public function setInterpolated($interpolated) {
        $this->interpolated = $interpolated;
        return $this;
    }

    /**
     * Get the value of code
     *
     * @return  mixed
     */
    public function getCode() {
        return $this->code;
    }

    /**
     * Set the value of code
     *
     * @param   mixed  $code  
     * @return  self
     */
    public function setCode($code) {
        $this->code = $code;
        return $this;
    }
}