<?php
namespace boru\dhdb\parser\expr;

use boru\dhutils\dhGlobal;

class BracketExpression extends Expression {
    public function expressionName() {
        return "Bracket";
    }
    public function getArray($options=[]) {
        return [
            "type"=>$this->expressionName(),
            "subTree"=>$this->subTree($options),
        ];
    }
    public function toSql($options=[],&$params=null) {
        $subTreeSql = $this->subTreeSql($options,$params);
        return "(" . implode(" ",$subTreeSql) . ")";
    }
}