<?php
namespace boru\dhdb\parser\expr;

use boru\dhutils\dhGlobal;

class Expression implements \JsonSerializable {
    private $data;

    public function __construct($data=[]) {
        foreach($data as $key=>$val) {
            if(is_array($val) && isset($val["expr_type"])) {
                $data[$key] = Expression::fromArray($val);
            } elseif(is_array($val) && dhGlobal::isList($val)) {
                $data[$key] = [];
                foreach($val as $v) {
                    if(is_array($v) && isset($v["expr_type"])) {
                        $data[$key][] = Expression::fromArray($v);
                    } else {
                        $data[$key][] = $v;
                    }
                }
            }
        }
        $this->data = new ExpressionData($data);
    }
    public function get($key=null,$defaultValue=false) {
        return $this->data->get($key,$defaultValue);
    }
    public function set($key,$value=null) {
        $this->data->set($key,$value);
        return $this;
    }

    public function expressionName() {
        return "Expression";
    }
    public function exprType() {
        return $this->get("expr_type");
    }
    public function type() {
        return $this->get("expr_type");
    }
    public function baseExpr() {
        return $this->get("base_expr");
    }
    public function base() {
        return $this->get("base_expr");
    }
    public function subTree($options=[]) {
        return $this->get("sub_tree");
    }
    public function position() {
        return $this->get("position");
    }
    public function parts() {
        return $this->get("no_quotes");
    }

    public function subTreeSql($options=[],&$params=null) {
        $subTree = $this->subTree($options);
        $subTreeSql = [];
        if(is_array($subTree) && (dhGlobal::isList($subTree) || empty($subTree))) {
            foreach($subTree as $expr) {
                if(is_object($expr) && $expr instanceof Expression) {
                    $subTreeSql[] = $expr->toSql($options,$params);
                }
            }
        } else {
            if(is_object($subTree) && $subTree instanceof Expression) {
                $subTreeSql[] = $subTree->toSql($options,$params);
            }
        }
        return $subTreeSql;
    }

    public static function fromArray($array) {
        if(isset($array["expr_type"])) {
            $exprType = $array["expr_type"];
            if($exprType == "table") {
                return new TableExpression($array);
            }
            if($exprType == "colref") {
                return new ColumnExpression($array);
            }
            if($exprType == "const") {
                return new ConstantExpression($array);
            }
            if($exprType == "operator") {
                return new OperatorExpression($array);
            }
            if($exprType == "bracket_expression") {
                return new BracketExpression($array);
            }
            if($exprType == "in-list") {
                return new InListExpression($array);
            }
            if($exprType == "function") {
                return new FunctionExpression($array);
            }
            if($exprType == "aggregate_function") {
                return new FunctionExpression($array);
            }
            if($exprType == "reserved") {
                return new ReservedExpression($array);
            }
            return new Expression($array);
        } else {
            return $array;
        }
    }

    public function getArray($options=[]) {
        return $this->data->toArray();
    }
    public function __toString() {
        return json_encode($this->toArray(),JSON_PRETTY_PRINT);
    }
    public function jsonSerialize() {
        return $this->toArray();
    }
    public function toArray($options=[]) {
        $arr = $this->getArray($options);
        foreach($arr as $k=>$v) {
            if($v instanceof Expression) {
                $arr[$k] = $v->toArray($options);
            }
        }
        return $arr;
    }
    public function toSql($options=[],&$params=null) {
        $arr = $this->getArray();
        foreach($arr as $k=>$v) {
            if($v instanceof Expression) {
                $arr[$k] = $v->toSql($options,$params);
            }
        }
        if(isset($arr["base_expr"])) {
            return $arr["base_expr"];
        }
    }
}