<?php
namespace boru\dhdb\parser\expr;

use boru\dhutils\dhGlobal;

class FunctionExpression extends Expression {
    public function expressionName() {
        return "Function";
    }
    public function func() {
        return $this->get("base_expr");
    }
    public function getArray($options=[]) {
        $return = [
            "type"=>$this->expressionName(),
            "func"=>$this->func(),
        ];
        if($this->subTree($options) !== false) {
            $return["subTree"] = $this->subTree($options);
        }
        return $return;
    }
    public function toSql($options=[],&$params=null) {
        $subTreeSql = $this->subTreeSql($options,$params);
        $return = $this->func() . "(". implode(",",$subTreeSql) .")";
        return $return;
    }
}