<?php
namespace boru\dhdb\parser\expr;

class InListExpression extends Expression {
    public function expressionName() {
        return "InList";
    }
    public function getArray($options=[]) {
        return [
            "type"=>$this->expressionName(),
            "subTree"=>$this->subTree($options),
        ];
    }
    public function toSql($options=[],&$params=null) {
        $subTreeSql = $this->subTreeSql($options,$params);
        return "(" . implode(",",$subTreeSql) . ")";
    }
}