<?php
namespace boru\dhdb\parser\expr;

use boru\dhutils\dhGlobal;

class TableExpression extends Expression {
    public function expressionName() {
        return "Table";
    }
    public function table() {
        if(($noQuotes = $this->get("no_quotes")) !== false) {
            return $noQuotes["parts"][0];
        }
        return $this->get("table");
    }
    public function alias() {
        $alias = $this->get("alias");
        if(is_array($alias) && isset($alias["no_quotes"])) {
            return $alias["no_quotes"]["parts"][0];
        }
        return $this->get("alias");
    }
    public function hints() {
        return $this->get("hints");
    }
    public function joinType() {
        return $this->get("join_type");
    }
    public function refType() {
        return $this->get("ref_type");
    }
    /**
     * @return Expression|Expression[]|false 
     */
    public function refClause() {
        return $this->get("ref_clause");
    }
    public function refClauseSql($options=[],&$params=null) {
        $refClause = $this->refClause();
        $refClauseSql = [];
        if(is_array($refClause) && dhGlobal::isList($refClause)) {
            foreach($refClause as $expr) {
                $refClauseSql[] = $expr->toSql($options,$params);
            }
        } else {
            $refClauseSql[] = $refClause->toSql($options,$params);
        }
        return $refClauseSql;
    }

    private function joinTypeSql() {
        if($this->refType() === false) {
            return;
        }
        switch($this->joinType()) {
            case "LEFT":
                return "LEFT JOIN";
            case "RIGHT":
                return "RIGHT JOIN";
            case "INNER":
            case "JOIN":
                return "INNER JOIN";
            case "CROSS":
                return "CROSS JOIN";
            case "STRAIGHT":
                return "STRAIGHT_JOIN";
            case "NATURAL":
                return "NATURAL JOIN";
            default:
                return "JOIN";
        }
    }

    public function getArray($options=[]) {
        $return = [
            "type"=>$this->expressionName(),
            "table"=>$this->table(),
        ];
        if($this->alias() !== false) {
            $return["alias"] = $this->alias();
        }
        if($this->hints() !== false) {
            $return["hints"] = $this->hints();
        }
        if($this->joinType() !== false) {
            $return["joinType"] = $this->joinType();
        }
        if($this->refType() !== false) {
            $return["refType"] = $this->refType();
        }
        if($this->refClause() !== false) {
            $return["refClause"] = $this->refClause();
        }
        if($this->subTree() !== false) {
            $return["subTree"] = $this->subTree();
        }
        return $return;
    }

    public function toSql($options=[],&$params=null) {
        $parts = [];
        if($this->joinType() !== false && $this->refType() !== false) {
            $parts[] = $this->joinTypeSql();
        }
        $parts[] = "`".$this->table()."`";
        if($this->alias() !== false) {
            $parts[] = "AS " . $this->alias();
        }
        if($this->hints() !== false) {
            $parts[] = $this->hints();
        }
        if($this->refType() !== false) {
            $parts[] = $this->refType();
        }
        if($this->refClause() !== false) {
            $refClauseSql = $this->refClauseSql($options,$params);
            $parts[] = implode(" ",$refClauseSql);
        }
        return implode(" ",$parts);
    }
}