<?php

use boru\dhcli\dhCLI;
use boru\dhcli\Option;
use boru\dhfw\FindDir;
use boru\dhfw\Setup;
use boru\dhutils\filesys\File;

require_once __DIR__."/../src/FindDir.php";

$rootDir = FindDir::findRootDirectory();
echo $rootDir."\n";
chdir($rootDir);
require_once 'vendor/autoload.php';

$file = File::fromInput($argv[0],false);

array_shift($argv);
$dhcli= new dhCLI([
    "name"=>"DHFW Install Script",
    "description"=>"Setupa and install DHFW",
    "script"=>"php -f ".$file->path()." "
]);
$dhcli->command(
    dhCLI::makeCommand([
        "command"=>"install",
        "description"=>"Install DHFW",
        "opts"=>[
            Option::flag(  "f", "force" ,    "Force install"),
            Option::option("d", "directory", "Directory to install to",true,["default"=>$rootDir]),
        ],
        "callback"=>function($result) {
            $force = isset($result["options"]["force"]) ? $result["options"]["force"] : false;
            try {
                Setup::install($result["options"]["directory"],$force);
            } catch (Exception $e) {
                echo "Error with install script..\n".$e->getMessage()."\n";
            }
        },
    ])
);

$dhcli->process($argv);