<?php
namespace boru\dhfw;

use boru\dhapi\core\Container;
use boru\dhapi\core\Dispatcher;
use boru\dhapi\API;
use boru\dhapi\routing\Route;
use boru\dhapi\routing\Router;
use boru\dhutils\dhGlobal;

class AppRouter {
    /** @var Container */
    private $vars;
    /** @var Container */
    private $args;
    /** @var Dispatcher */
    private $api;

    private $moduleName;
    private $viewName;
    private $actionName;
    private $recordId;

    private $module;
    private $view;
    private $action;
    private $record;

    private static $baseNS = null;

    /**
     * @param Dispatcher $api 
     * @return void 
     */
    public function process($api) {
        $this->vars = $api->getArgs();
        $this->args = new Container($api->getRequest()->body());
        $this->parseVars($this->vars);
        header("Content-Type: application/json");
        echo json_encode($this->args,JSON_PRETTY_PRINT);
        echo "\n\n";
        echo json_encode($this->vars,JSON_PRETTY_PRINT);
        echo "\n\n";
        if($this->getModule() !== false) {
            print_r($this->getModule()->getInfo());
        }
        exit();
    }

    public function get($key,$default=null) {
        return $this->args->get($key,$default);
    }
    public function getVar($key,$default=null) {
        return $this->vars->get($key,$default);
    }
    public function header($key,$default=null) {
        return $this->api->header($key,$default);
    }

    public function getModule() {
        if(is_null($this->module)) {
            if(($className = $this->getClassName("Module")) !== false) {
                $this->module = new $className();
            } else {
                $this->module = new \boru\dhfw\app\basemodule\Module();
            }
        }
        return $this->module;
    }
    public function getView() {
        if(is_null($this->view)) {
            if(($className = $this->getClassName("views\\".$this->viewName)) !== false) {
                $this->module = new $className();
            } else {
                $this->view = new \boru\dhfw\app\basemodule\views\NotFound();
            }
        }
        return $this->view;
    }
    public function getAction() {
        if(is_null($this->action)) {
            if(($className = $this->getClassName("actions\\".$this->viewName)) !== false) {
                $this->module = new $className();
            } else {
                $this->action = new \boru\dhfw\app\basemodule\actions\NotFound();
            }
        }
        return $this->action;
    }

    private function parseVars($vars) {
        $this->moduleName   = $vars->get( "module", null);
        $this->viewName     = $vars->get( "view",   null);
        $this->actionName   = $vars->get( "action", null);
        $this->recordId     = $vars->get( "id",     null);
    }
    private function parseArgs($args=[]) {
        $this->moduleName   = dhGlobal::getVal($args, "module", null);
        $this->viewName     = dhGlobal::getVal($args, "view",   null);
        $this->actionName   = dhGlobal::getVal($args, "action", null);
        $this->recordId     = dhGlobal::getVal($args, "id",     null);
    }

    public function getArgs() {
        return $this->args;
    }
    public function getModuleName() {
        return $this->moduleName;
    }
    public function getViewName() {
        return $this->viewName;
    }
    public function getActionName() {
        return $this->actionName;
    }
    public function getRecordId() {
        return $this->recordId;
    }
    private static $classNameFallbackOrder = [
        "{APPNS}\\{MODULE}",
        "\\boru\\dhfw\\app\\{MODULE}",
        "{APPNS}\\basemodule",
        "\\boru\\dhfw\\app\\basemodule",
    ];
    public function getClassName($part=null) {
        $appns = self::getBaseNS();
        $module = $this->moduleName;
        foreach(static::$classNameFallbackOrder as $classNames) {
            $className = str_replace("{APPNS}",$appns,$classNames);
            $className = str_replace("{MODULE}",$module,$className);
            if(!is_null($part)) {
                $className .= "\\".$part;
            }
            echo "Checking $className\n";
            if(class_exists($className)) {
                return $className;
            }
        }
        return false;
    }

    public static function setBaseNS($baseNS) {
        self::$baseNS = $baseNS;
    }
    public static function getBaseNS() {
        return self::$baseNS;
    }
    public static function launch($baseNS=null) {
        if(is_null($baseNS)) {
            $baseNS = DHFW::getConfig("baseNamespace","\\FWAPP");
        }
        self::setBaseNS($baseNS);
        $router = new Router();
        $router->add(new Route("mod/id/action", "/{module}/{id}/a/{action}",  ["GET","POST"], ["\\boru\\dhfw\\AppRouter","process"]));
        $router->add(new Route("mod/id/view",   "/{module}/{id}/{view}",      ["GET","POST"], ["\\boru\\dhfw\\AppRouter","process"]));
        $router->add(new Route("mod/action",    "/{module}/a/{action}",       ["GET","POST"], ["\\boru\\dhfw\\AppRouter","process"]));
        $router->add(new Route("mod/view",      "/{module}/{view}",           ["GET","POST"], ["\\boru\\dhfw\\AppRouter","process"]));
        $router->add(new Route("mod",           "/{module}",                  ["GET","POST"], ["\\boru\\dhfw\\AppRouter","process"]));
        $router->add(new Route("default",       "/",                          ["GET","POST"], ["\\boru\\dhfw\\AppRouter","process"]));
        $request = API::requestFromGlobals();
        $api = new API($request,$router);
        $response = $api->process();
        $response->emit(true);
    }
}