<?php
namespace boru\dhfw;

use boru\dhfw\util\Config;
use \boru\dhutils\filesys\Directory;

class DHFW {
    /** @var Config */
    private static $config;
    /** @var Directory */
    private static $rootDir;

    private static $namespaceBase = "FWAPP\\";

    public static function init($rootDirectory=null) {
        if(is_null($rootDirectory)) {
            $rootDirectory = new \boru\dhutils\filesys\Directory(["path"=>__DIR__.'/../']);
        } else {
            $rootDirectory == Directory::fromInput($rootDirectory);
        }
        if(!($rootDirectory instanceof Directory)) {
            throw new \Exception("DHFW::init() requires a Directory object");
        }
        static::$rootDir = $rootDirectory;
        static::$config = Config::fromFile(static::dir("config.json"));
    }


    // Config shortcuts
    /** 
     * Get a config value by dot notation, or the entire config array. Returns $default if not found
     * @param string $key
     * @param mixed $default
     * @return mixed
     */
    public static function getConfig($key=null,$default=null) {
        return static::$config->get($key,$default);
    }

    /**
     * Set a config value by dot notation
     * @param mixed $key 
     * @param mixed $value 
     * @return Config 
     */
    public static function setConfig($key,$value) {
        return static::$config->set($key,$value);
    }

    /**
     * Save the config file
     * @return Config 
     */
    public static function saveConfig() {
        return static::$config->save();
    }

    /**
     * Get the config object
     * @return Config 
     */
    public static function config() {
        return static::$config;
    }

    /**
     * Get the root directory path string, or a path relative to the root directory
     * @param mixed $path 
     * @return string 
     */
    public static function dir($path=null) {
        return static::$rootDir->path($path);
    }

    public static function install($directory=null,$force=false) {
        //make sure we're running from cli and not a webserver
        if(php_sapi_name() !== "cli") {
            throw new \Exception("DHFW::install() must be run from the command line");
        }
        Setup::install($directory,$force);
    }
}