<?php
namespace boru\dhfw;

class FindDir {
    public static function findRootDirectory($directory=null) {
        if(is_null($directory) || empty($directory)) {
            $directory = __DIR__;
        }
        $dirParts = explode(DIRECTORY_SEPARATOR,$directory);
                
        if(($dir = static::isVendorParentDir($directory)) !== false) {
            //config.inc.php exists in this directory.. weird but ok..
            return $dir;
        }

        $continue=true;
        while($continue) {
            $dropoff = array_pop($dirParts);
            if(empty($dirParts)) {
                $continue=false;
                break;
            }
            $dirPath = implode(DIRECTORY_SEPARATOR,$dirParts);
            if(($dir = static::isVendorParentDir($dirPath)) !== false) {
                return $dir;
            }
        }
        return false;
    }
    private static function isVendorParentDir($directory) {
        if(!is_dir($directory)) {
            return false;
        }
        //it should have a vendor directory and a composer.json file
        if(is_dir($directory.DIRECTORY_SEPARATOR."vendor") && is_file($directory.DIRECTORY_SEPARATOR."composer.json")) {
            return $directory;
        }
        return false;
    }
}