<?php
namespace boru\dhfw;

use boru\dhfw\util\Config;
use boru\dhutils\dhGlobal;
use boru\dhutils\filesys\Directory;

class Setup {
    private static $rootDirectory = null;
    public static function install($directory=null,$force=false) {
        if(is_null($directory)) {
            $directory = FindDir::findRootDirectory();
        }
        if($directory === false) {
            throw new \Exception("Could not find root directory");
        }
        if(!is_dir($directory)) {
            throw new \Exception("Root directory is not a directory");
        }
        if(!is_writable($directory)) {
            throw new \Exception("Root directory is not writable");
        }
        if(!is_dir($directory."/vendor")) {
            throw new \Exception("Root directory does not contain a vendor directory");
        }
        if(!is_file($directory."/composer.json")) {
            throw new \Exception("Root directory does not contain a composer.json file");
        }

        static::copyFile($directory,"/init.php",$force);

        static::createDirectory($directory,"/app",$force);
        static::createDirectory($directory,"/public",$force);
        static::createDirectory($directory,"/scripts",$force);
        static::createDirectory($directory,"/storage",$force);
        static::createDirectory($directory,"/public/css",$force);
        static::createDirectory($directory,"/public/img",$force);
        static::createDirectory($directory,"/public/js",$force);

        static::copyFile($directory,"/public/index.php",$force);
        static::copyFile($directory,"/public/.htaccess",$force);

        static::copyFile($directory,"/public/css/.htaccess",$force);
        static::copyFile($directory,"/public/img/.htaccess",$force);
        static::copyFile($directory,"/public/js/.htaccess",$force);

        //config.json setup
        static::checkConfig($directory."/config.json");
    }

    public static function createDirectory($directory,$item,$force=false) {
        $path = $directory.$item;
        if(!is_dir($path) || $force) {
            dhGlobal::outLine("+","Creating:",$item);
            Directory::fromPathString($path,true);
        } else {
            dhGlobal::outLine(" ","exists:  ",$item);
        }
    }
    public static function copyFile($directory,$item,$force=false) {
        $path = $directory.$item;
        $source = __DIR__."/..".$item;
        if(!file_exists($path) || $force) {
            dhGlobal::outLine("+","Copying: ",$item);
            copy($source,$path);
        } else {
            dhGlobal::outLine(" ","exists:  ",$item);
        }
    }

    private static $defaultConfig = [
        "siteUrl"       => "",
        "siteName"      => "",
        "baseNamespace" => "\\FWAPP",
        "db"=>[
            "dbtype"    => "mysql",
            "host"      => "",
            "user"      => "",
            "pass"      => "",
            "name"      => ""
        ],
    ];
    public static function checkConfig($configFile) {
        $config = Config::fromFile($configFile);
        $updated=false;
        foreach(static::$defaultConfig as $key=>$value) {
            if(!$config->has($key)) {
                $config->set($key,$value);
                $updated=true;
            }
        }
        if($updated) {
            $config->save();
        }
    }
}