<?php
namespace boru\dhfw\util;

use \boru\dhutils\filesys\File;
use \boru\dhutils\dhGlobal;
use \boru\dhutils\base\dhObject;

class Config extends dhObject implements \JsonSerializable {
    protected $data = null;
    protected $prettyJson = true;
    protected $sort = true;
    protected $file;
    public function __construct($options=[]) {
        if(($fileopt = dhGlobal::getVal($options,"file",null)) === null) {
            if(($fileopt = dhGlobal::getVal($options,"fileName",null)) === null) {
                if(($fileopt = dhGlobal::getVal($options,"path",null)) === null) {
                    throw new \Exception("ConfigFile requires a file ,fileName or path defined");
                }
            }
        }
        if(!is_object($fileopt)) {
            $this->file = new File(["path"=>$fileopt,"create"=>true]);
        } else {
            $this->file = $fileopt;
        }
        $this->prettyJson = dhGlobal::getVal($options,"prettyJson",$this->prettyJson);
        $this->sort = dhGlobal::getVal($options,"sort",$this->sort);

        $this->load();
    }

    public function load() {
        $content = $this->file->content(["json"=>true]);
        $this->data = [];
        if(is_array($content) && !empty($content)) {
            if($this->sort) {
                ksort($this->data);
            }
            foreach($content as $k=>$v) {
                $this->set($k,$v);
            }
        }
        return $this;
    }
    public function save() {
        if($this->sort) {
            ksort($this->data);
        }
        if($this->prettyJson) {
            $this->file->write(json_encode($this,JSON_PRETTY_PRINT));
        } else {
            $this->file->write(json_encode($this));
        }
        return $this;
    }

    public function has($key) {
        $test = $this->get($key,"ZZ--NOTFOUND--ZZ");
        return $test !== "ZZ--NOTFOUND--ZZ";
    }

    /**
     * Shortcut to create an instance from a file
     * @param string|File $file 
     * @return ConfigFile 
     */
    public static function fromFile($file) {
        return new static(["file"=>$file,"prettyJson"=>true]);
    }
}