<?php
namespace boru\dhfw\util;

use boru\dhfw\DHFW;

class FWSmarty {
    /** @var \Smarty */
    private static $smarty;

    private static $options = [
        "templateDir" => "{fw}/app",
        "configDir" => "{fw}/smarty",
        "compileDir" => "{fw}/cache/smarty/compiled",
        "cacheDir" => "{fw}/cache/smarty/cache",
        "caching" => \Smarty::CACHING_OFF,
    ];
    public static function createInstance($options=[]) {
        static::applyOptions($options);
        $smarty = new \Smarty();
        $smarty->setTemplateDir(    static::templateDir() );
        $smarty->setConfigDir(      static::configDir()   );
        $smarty->setCompileDir(     static::compileDir()  );
        $smarty->setCacheDir(       static::cacheDir()    );
        $smarty->caching  =         static::$options["caching"];
    }
    public static function instance($force=false) {
        if(!static::$smarty || $force) {
            static::createInstance();
        }
        return static::$smarty;
    }
    public static function templateDir() {
        return static::applyFwDir(static::$options["templateDir"]);
    }
    public static function configDir() {
        return static::applyFwDir(static::$options["configDir"]);
    }
    public static function compileDir() {
        return static::applyFwDir(static::$options["compileDir"]);
    }
    public static function cacheDir() {
        return static::applyFwDir(static::$options["cacheDir"]);
    }
    public static function setOption($key,$value) {
        static::$options[$key] = $value;
    }
    public static function applyOptions($options) {
        if(is_array($options) && !empty($options )) {
            foreach($options as $key=>$value) {
                if(isset(static::$options[$key])) {
                    static::$options[$key] = $value;
                }
            }
        }
    }
    private static function applyFwDir($path) {
        return str_replace("{fw}/",DHFW::dir(),$path);
    }
}