<?php

use boru\dhcli\dhCLI;
use boru\dhcli\Option;
use boru\dhfw\util\FindDir;
use boru\dhfw\util\FWSetup;
use boru\dhutils\filesys\File;

require_once __DIR__."/src/util/FindDir.php";

$rootDir = FindDir::findRootDirectory();
chdir($rootDir);
require_once 'vendor/autoload.php';

$file = File::fromInput($argv[0],false);

array_shift($argv);
$dhcli= new dhCLI([
    "name"=>"DHFW Install Script",
    "description"=>"Setupa and install DHFW",
    "script"=>"php -f ".$file->path()." "
]);
$dhcli->command(
    dhCLI::makeCommand([
        "command"=>"install",
        "description"=>"Install DHFW",
        "opts"=>[
            Option::flag(  "f", "force" ,    "Force install"),
            Option::option("d", "directory", "Directory to install to",true,["default"=>$rootDir]),
        ],
        "callback"=>function($result) {
            $force = isset($result["options"]["force"]) ? $result["options"]["force"] : false;
            try {
                FWSetup::install($result["options"]["directory"],$force);
            } catch (Exception $e) {
                echo "Error with install script..\n".$e->getMessage()."\n";
            }
        },
    ])
);

$dhcli->process($argv);