<?php
namespace boru\dhfw;

use boru\dhcli\dhCLI;
use boru\dhutils\dhGlobal;

class FWCli {
    private $args = [];
    private $commandName = "";
    private static $scriptName = "";
    public function __construct($args) {
        $this->args = $args;
        if(empty($args)) {
            $this->args = ["list"];
        }
        $command = array_shift($this->args);
        if($command == "help") {
            if(!empty($this->args)) {
                $command = array_shift($this->args);
                array_unshift($this->args,"help");
            } else {
                //$command = "list";
            }
        }
        $this->process($command);
    }

    public function commandName() {
        return $this->commandName;
    }
    public function scriptName() {
        return static::$scriptName;
    }
    public function args() {
        return $this->args;
    }

    public static function launch($args,$scriptName="") {
        static::makeCli($scriptName);
        $instance = new static($args);
    }

    public function process($command = "list") {
        $commandClass = static::commandToClass($command);
        $this->commandName = static::commandNameFromClass($commandClass);
        try {
            $commandClass->trigger($this);
        } catch(\Exception $e) {
            dhGlobal::outLine("Error processing command:",$e->getMessage());
        }
    }

    public static function commandToClass($commandString) {
        $command = explode("/",$commandString);
        $moduleName = "";
        $className = "";
        if(count($command) <= 0) {
            $moduleName = "basemodule";
            $className = "List";
        } elseif(count($command) == 1) {
            $moduleName = "basemodule";
            $className = $command[0];
        } else {
            $moduleName = $command[0];
            $className = $command[1];
        }
        if(($class = AppRouter::searchClass($moduleName,$className,"command")) !== false) {
            return new $class();
        } else {
            return static::listCommand($moduleName);
        }
    }
    public static function listCommand($moduleName="basemodule") {
        if(($className = AppRouter::searchClass($moduleName,"NotFound","command")) !== false) {
            return new $className();
        } else {
            return new \boru\dhfw\app\basemodule\commands\ListCommand();
        }
    }

    public static function commandNameFromClass($class) {
        if(is_object($class)) {
            $class = get_class($class);
        }
        $class = explode("\\",$class);
        $commandName = array_pop($class);
        $commandName = preg_replace("/Command$/","",$commandName);
        array_pop($class); //'commands'
        $moduleName = array_pop($class);
        if($moduleName == "basemodule") {
            return $commandName;
        }
        return $moduleName."/".$commandName;
    }

    private static $dhCli = null;
    public static function dhCli() {
        if(static::$dhCli === null) {
            static::$dhCli = static::makeCli();
        }
        return static::$dhCli;
    }
    public static function makeCli($scriptName="") {
        static::$scriptName = $scriptName;
        return new dhCli([
            "name"=>DHFW::getConfig("siteName","DHFW")." CLI Utility",
            //"name"=>"DHFW Cli",
            "description"=>"",
            "script"=>$scriptName." ",
        ]);
    }
}