<?php
namespace boru\dhfw\app\basemodule\commands;

use boru\dhcli\Option;
use boru\dhfw\AppRouter;
use boru\dhfw\base\BaseCommand;
use boru\dhfw\DHFW;
use boru\dhutils\dhGlobal;
use boru\dhutils\filesys\Directory;

class CreateCommand extends BaseCommand {
    public static $commandDescription = "Create a new module in the app/ directory";
    
    public static function commandOptions() {
        return [
            Option::positional("moduleName","Name of the module to create",true),
        ];
    }

    public function process() {
        $moduleName = $this->get("moduleName");
        $ucFirst = ucfirst($moduleName);
        $lower = strtolower($moduleName);
        $moduleDir = AppRouter::parseClassToDir("\\boru\\dhfw\\app\\basemodule","basemodule");
        $file = dhGlobal::fileIfExists($moduleDir."/Module.php");
        if(!$file) {
            dhGlobal::outLine("Module file does not exist");
            return;
        }
        $directory = new Directory(["path"=>DHFW::dir("app/")]);
        if(dhGlobal::dirIfExists($directory->path($lower))) {
            dhGlobal::outLine("Module",$moduleName,"already exists");
            return;
        }

        static::createModuleDirectory($moduleName);
        $content = static::getModuleFileContent($moduleName);
        file_put_contents($directory->path($lower)."/".$ucFirst.".php",$content);

    }

    public static function createModuleDirectory($moduleName) {
        $lower = strtolower($moduleName);
        $directory = new Directory(["path"=>DHFW::dir("app/")]);
        $moduleDir = $directory->path($lower);
        @mkdir($moduleDir);
        @mkdir($moduleDir."/actions");
        @mkdir($moduleDir."/apis");
        @mkdir($moduleDir."/commands");
        @mkdir($moduleDir."/templates");
        @mkdir($moduleDir."/views");
        return true;
    }
    public static function getModuleFileContent($moduleName) {
        $ucFirst = ucfirst($moduleName);
        $lower = strtolower($moduleName);
        $moduleDir = AppRouter::parseClassToDir("\\boru\\dhfw\\app\\basemodule","basemodule");
        if(($file = dhGlobal::fileIfExists($moduleDir."/Module.php")) !== false) {
            $content = $file->content();
            $content = str_replace("class Module extends BaseModule","class $ucFirst extends \\boru\\dhfw\\app\\basemodule\\Module",$content);
            $content = str_replace('"Core"',"'$ucFirst'",$content);
            $content = str_replace("namespace boru\\dhfw\\app\\basemodule","namespace boru\\dhfw\\app\\$lower",$content);
            return $content;
        }
        return false;
    }
}