<?php
namespace boru\dhfw\app\user;

use boru\dhfw\base\BaseModule;
use boru\dhfw\base\UserInterface;

class User extends BaseModule implements UserInterface {

    protected static $moduleName = "User";
    protected static $isRecordModule = false;
    protected static $sqlTable = "user";
    protected static $idField = "id";
    protected static $createdTimeField = "createdTime";
    protected static $modifiedTimeField = "modifiedTime";
    
    public function __construct() {
        parent::__construct();
    }

    public function getDisplayName() {
        return $this->get("name", "Anonymous");
    }

    public function getId() {
        return $this->get("id", 0);
    }

    public function isPermissed() {
        return false;
    }

    public function isAuthed() {
        return false;
    }

    public function authenticate($data = []) {
        return false;
    }

    public function logout() {
        return true;
    }

    public function sessionAuthenticate() {
        return false;
    }

}