<?php
namespace boru\dhfw\base;

use boru\dhfw\DHFW;
use boru\dhfw\util\Container;
use boru\dhfw\util\Debug;
use boru\dhfw\util\QueryConditions;
use boru\dhutils\dhGlobal;
use boru\dhutils\filesys\Directory;
use ReflectionClass;

abstract class BaseModule extends BaseModuleRecord {

    //all of these variables are commented and defined in BaseModuleRecord
    protected static $moduleName = "Module";
    protected static $isRecordModule = true;
    protected static $sqlTable = "";
    protected static $sqlExtraTables = [];
    protected static $sqlTableJoins = [];
    protected static $idField = "";
    protected static $createdTimeField = "";
    protected static $modifiedTimeField = "";
    protected static $labelField = "";

    protected static $jsonFields = [];
    protected static $serializedFields = [];

    
    protected static $Static_SQLDebug = false;
    /**
     * The default view to use for this module
     * @var string
     */
    protected static $defaultView = "Home";

    public static function initDefaults() {
        if(static::$isRecordModule) {
            static::initSqlDefaults();
        }
    }

    public static function getDefaultViewName() {
        return static::$defaultView;
    }

    public static function setSqlDebug($debug) {
        static::$Static_SQLDebug = $debug;
    }

    public static function getModuleName() {
        return static::$moduleName;
    }

    /**
	 * 
	 * @param string $field 
	 * @param string $value 
	 * @param int $offset 
	 * @param int $limit 
	 * @param string $orderby 
	 * @param string $orderdir 
	 * @param string $groupby 
	 * @param string $comparator 
	 * @return false|static[] 
	 */
	public static function search($field="",$value="",$offset=0,$limit=0,$orderby="",$orderdir="",$groupby="",$comparator="eq") {
	    $db = DHFW::db();
		$sql = "SELECT * FROM ";
        $sql.= static::SQLTableWithJoins();
        $values = [];
        $whereConditions = new QueryConditions();
		if(is_array($field) || !empty($field)) {
            if(is_array($field)) {
			    $whereConditions->addArray($field);
		    } else {
			    $whereConditions->add($field,$value,$comparator);
            }
            $sql.=" ".$whereConditions->getSQL("WHERE");
		    $values = $whereConditions->getValues();
		} else {
            
        }
		if($orderby != "") {
			$sql.=" ORDER BY $orderby $orderdir";
		}
		if($limit>=1) {
			$sql.=" LIMIT ?,?";
			$values[] = $offset;
			$values[] = $limit;
		}
        if(static::$Static_SQLDebug) {
            dhGlobal::outLine("SQLDebug(static)",$sql,"::::",$values);
        }
		$sth=$db->run($sql,$values);
		$return = array();
		while($row=$db->next($sth)) {
			$obj = new static();
			$obj->populate($row->toArray());
			$return[] = $obj;
		}
		if(empty($return)) return false;
		return $return;
	}

    /**
	 * 
	 * @param mixed $field 
	 * @param int $offset 
	 * @param int $limit 
	 * @param string $orderby 
	 * @param string $orderdir 
	 * @return false|array 
	 */
	public static function searchDistinct($field,$offset=0,$limit=0,$orderby="",$orderdir="") {
		$db = DHFW::db();
		$sql = "select DISTINCT `".$field."` FROM ";
        $sql.= static::SQLTableWithJoins();
		$values = array();
		if($limit>=1) {
			$sql.=" LIMIT ?,?";
			$values[] = $offset;
			$values[] = $limit;
		}
		if($orderby != "") {
			$sql.=" ORDER BY $orderby $orderdir";
		}
        if(static::$Static_SQLDebug) {
            dhGlobal::outLine("SQLDebug(static)",$sql,"::::",$values);
        }
		$sth=$db->run($sql,$values);
		$return = array();
		while($row=$db->next($sth)) {
			$return[] = $row[$field];
		}
		if(empty($return)) return false;
		return $return;
	}

    /**
	 * 
	 * @param mixed $field 
	 * @param string $value 
	 * @param string $comparator 
	 * @return false|static 
	 */
	public static function getOne($field,$value="",$comparator="eq") {
		$data = static::search($field,$value,0,1,"","","",$comparator);
		if(empty($data)) return false;
		return $data[0];
	}

	/**
	 * 
	 * @param array $array 
	 * @return static 
	 */
	public static function create($array=array()) {
		global $dbh;
		$obj = new static();
		if(!empty($array)) {
			$obj->populate($array);
			$obj->save(true);
			$obj->setNew(true);
		}
		return $obj;
	}

    /**
	 * 
	 * @param mixed $array 
	 * @param string $comparator 
	 * @return static 
	 */
	public static function getOrCreate($array,$comparator="eq") {
		$data = static::getOne($array,"",$comparator);
		if(!$data) {
			$data = static::create();
			$data->populate($array);
			$data->save(true);
			$data->setNew(true);
		}
		return $data;
	}

    /**
	 * 
	 * @param mixed $value 
	 * @return false|static 
	 */
	public static function getById($value) {
		return static::getOne(static::$idField,$value,"eq");
	}

    private $debugSql = false;
    protected $id;
    protected $data;
    protected $isNew;
    public function get($key=null,$default=null) {
        return $this->data->get($key,$default);
    }
    public function set($key,$value) {
        $this->data->set($key,$value);
    }
    public function setNew($new) {
        $this->isNew = $new;
    }
    public function isNew() {
        return $this->isNew;
    }
    public function setId($id) {
        $this->id = $id;
    }
    public function id() {
        return $this->id;
    }
    public function debugSql($debug=true) {
        $this->debugSql = $debug;
    }

    public function __construct() {
        static::initDefaults();
        $this->data = new Container();
    }

    //Overridable save action
	public function save($date=true) {
		$this->_save($date);
		return $this;
	}
    public function _save($date=true,$forceId=false) {
        $db = DHFW::db();
        $data = $this->data->get();
        foreach($data as $k=>$v) {
            if($v === null) {
                unset($data[$k]);
            }
            if(is_array($v) || is_object($v)) {
                if(in_array($k,static::$jsonFields)) {
                    $data[$k] = json_encode($v);
                } elseif(in_array($k,static::$serializedFields)) {
                    $data[$k] = serialize($v);
                }
            }
        }

        $idField = static::$idField;
        if($this->isNew() && !$forceId) {
            $sqlInfo = static::SQLInsertQuery($data,$date);
            if($this->debugSql) {
                dhGlobal::outLine("SQLDebug(record)",$sqlInfo["sql"],"::::",$sqlInfo["values"]);
            }
            $db->run($sqlInfo["sql"],$sqlInfo["values"]);
            $this->setId($db->lastInsertId());
            $this->setNew(false);
        } else {
            $whereConditions = [static::$idField=>$this->id()];
            $sqlInfo = static::SQLUpdateQuery($data,$whereConditions,$date);
            if($this->debugSql) {
                dhGlobal::outLine("SQLDebug(record)",$sqlInfo["sql"],"::::",$sqlInfo["values"]);
            }
            $db->run($sqlInfo["sql"],$sqlInfo["values"]);
        }
        if($this->id()) {
            return true;
        }
        return false;
    }

    public function populate($data) {
        $idField = static::$idField;
        if(isset($data[$idField])) {
            $this->setId($data[$idField]);
        }
        foreach($data as $k=>$v) {
            if(in_array($k,static::$jsonFields)) {
                $v = json_decode($v,true);
            } elseif(in_array($k,static::$serializedFields)) {
                $v = unserialize($v);
            }
            $this->set($k,$v);
        }
    }

    public function load($id) {
        $data = static::getById($id);
        if(!$data) return false;
        $this->populate($data->get());
        $this->setId($id);
        $this->setNew(false);
        return true;
    }
}