class AppConnector {
    constructor(url=null,data=null,dataType='json') {
        this.url = url;
        this.data = data;
        this.dataType = dataType;
    }
    url(url=null) {
        if(typeof url === 'undefined' || url==null) {
            return this.url;
        }
        this.url = url;
    }
    data(key,value=null) {
        if(typeof key === 'object') {
            this.data = key;
        }else if(typeof key === 'string') {
            if(typeof value === 'undefined' || value === null) {
                return this.data[key];
            }else{
                this.data[key] = value;
            }
        }
    }
    dataType(dataType=null) {
        if(typeof dataType === 'undefined' || dataType==null) {
            return this.dataType;
        }
        this.dataType = dataType;
    }
    ajax() {
        let settings = {
            url: this.url,
            data: this.data,
            dataType: this.dataType
        };
        return AppConnector.ajax(this.url,settings);
    }
    static setBaseUrl(baseUrl=null) {
        if(baseUrl==null) {
            baseUrl = document.getElementById('baseUrl').value;
        }
        AppConnector.baseUrl = baseUrl;
    }
    static getBaseUrl() {
        if(AppConnector.baseUrl==null) {
            AppConnector.setBaseUrl();
        }
        return AppConnector.baseUrl;
    }
    static ajax(url, settings={}) {
        if(typeof settings !== 'object') {
            settings = {
                method: 'GET'
            };
        }
        let fullUrl = AppConnector.getBaseUrl() + url;
        return $.ajax(fullUrl, settings);
    }

    static get(url, settings={}) {
        if(typeof settings !== 'object') {
            settings = {};
        }
        settings.method = 'GET';
        return this.ajax(url, settings);
    }
    static post(url, settings={}) {
        if(typeof settings !== 'object') {
            settings = {};
        }
        settings.method = 'POST';
        return this.ajax(url, settings);
    }
    static put(url, settings={}) {
        if(typeof settings !== 'object') {
            settings = {};
        }
        settings.method = 'PUT';
        return this.ajax(url, settings);
    }
}