<?php
namespace boru\dhfw\app\basemodule\commands;

use boru\dhcli\Option;
use boru\dhfw\AppRouter;
use boru\dhfw\base\BaseCommand;
use boru\dhfw\DHFW;
use boru\dhutils\dhGlobal;

class ModulesCommand extends BaseCommand {
    public static $commandDescription = "Lists the modules available in the system";
    
    public static function commandOptions() {
        return [
            Option::flag(  "s", "systemMods" , "Show internal, non-overridden modules as well"),
            Option::flag(  "c", "className", "Show class name instead of module name"),
        ];
    }

    public function process() {
        dhGlobal::outLine("Modules command");
        $systemMods = $this->get("systemMods",false);
        $useClassName = $this->get("className",false);
    
        $moduleList = [];
        
        if($systemMods) {
            $moduleList = AppRouter::listModules("system");
        }
        $moduleList = array_merge($moduleList,AppRouter::listModules("app"));
        
        $longestName = 0;
        foreach($moduleList as $moduleName=>$className) {
            if($useClassName) {
                $longestName = max($longestName,strlen($className));
            } else {
                $longestName = max($longestName,strlen($moduleName));
            }
        }

        foreach($moduleList as $moduleName=>$className) {
            $display = dhGlobal::padRight($useClassName ? $className : $moduleName,$longestName+2," ");
            dhGlobal::outLine(" ",$display,$className);
        }
    }
}