<?php
namespace boru\dhfw\app\basemodule\views;

class NotAuthorized extends View {
    private $trace;
    private $exception;

    protected $requiresAuth = false;

    public function setException($exception) {
        $this->exception = $exception;
    }
    public function init() {
        
    }
    public function process() {
        if(!is_null($this->exception) && $this->exception instanceof \Exception) {
            $this->viewer->assign("message",$this->exception->getMessage());
            $this->viewer->assign("code",$this->exception->getCode() > 0 ? $this->exception->getCode() : 403);
        } else {
            $this->viewer->assign("message","Not Authorized");
            $this->viewer->assign("code",403);
        }
        
        $this->viewer->display("NotAuthorized.tpl");
    }
}