<?php
namespace boru\dhfw\util;

class QueryConditions {
    private $qFields;
    private $qVals;
    private $limit;
    private $offset;

    public function __construct() {
        $this->qFields = [];
        $this->qVals = [];
    }

    public function addArray($fields,$comparator="eq") {
        foreach($fields as $field=>$value) {
            $this->add($field,$value,$comparator);
        }
    }
    public function add($field,$value,$comparator="eq") {
        if($comparator == "=" || $comparator == "eq") {
			$this->qFields[] = "`$field`=?";
		} elseif($comparator == "!=" || $comparator == "neq") {
			$this->qFields[] = "`$field`!=?";
		} elseif($comparator == ">" || $comparator == "gt") {
			$this->qFields[] = "`$field`>?";
		} elseif($comparator == ">=" || $comparator == "gte") {
			$this->qFields[] = "`$field`>=?";
		} elseif($comparator == "<" || $comparator == "lt") {
			$this->qFields[] = "`$field`<?";
		} elseif($comparator == "<=" || $comparator == "lte") {
			$this->qFields[] = "`$field`<=?";
		} elseif($comparator == "s%" || $comparator == "starts_with") {
			$this->qFields[] = "`$field` LIKE ?";
			$value.="%";
		}
		$this->qVals[] = $value;
    }

    public function getSQL($prefix="WHERE ") {
        $sql = "WHERE 1 AND ";
        if(empty($this->qFields)) {
            return $sql;
        }
        return $sql.implode(" AND ",$this->qFields);
    }
    public function getFields() {
        return $this->qFields;
    }
    public function getValues() {
        return $this->qVals;
    }
}