<?php
namespace boru\dhfw\app\basemodule\actions;

class CreateAction extends Action {
    protected $requiresAuth = true;
    
    public function process() {
        $module = $this->module();
        $array = [];
        foreach($module::moduleFields() as $field) {
            $field->capture($this->appRouter);
            $array[$field->name()] = $field->value();
        }
        if(!empty($array)) {
            $record = $module::create($array);
            $record->save();
            $this->set("url",$this->viewer->viewUrl($module::getModuleName(),"detail",$record->id()));
            $this->set("message","Success");
            echo json_encode($this->packetSuccess(),JSON_PRETTY_PRINT|JSON_UNESCAPED_SLASHES);
            return;
        } else {
            echo json_encode($this->packetError("No data received"),JSON_PRETTY_PRINT|JSON_UNESCAPED_SLASHES);
            return;
        }
    }
}