<?php
namespace boru\dhfw\app\basemodule\fields;

use boru\dhfw\AppRouter;

class RefField extends Field {
    public function __construct($data=[]) {
        $data["type"] = "ref";
        if(!isset($data["cssClasses"])) {
            $data["cssClasses"] = "form-control";
        } elseif(strpos($data["cssClasses"],"form-control")===false) {
            $data["cssClasses"] .= " form-control";
        }
        parent::__construct($data);

        if(!isset($data["options"])) {
            $options = [];
            $appRouter = AppRouter::getInstance();
            $module = $appRouter->getmodule($this->refModule());
            $records = $module::search();
            $labelField = $this->refLabelField();
            $idField = $this->refIdField();
            foreach($records as $record) {
                $options[$record->get($idField)] = $record->get($labelField);
            }
            $this->options($options);
        }
    }
    public function displayValue() {
        $appRouter = AppRouter::getInstance();
        $module = $appRouter->getmodule($this->refModule());
        $record = $module::getById($this->value());
        $labelField = $this->refLabelField();
        return $record->get($labelField);
    }
}