<?php
namespace boru\dhfw\base;

use boru\dhfw\util\Container;

abstract class BaseApi extends BaseView {
        
    protected $displayHeader = false;
    protected $displayFooter = false;

    private $data;

    public function __construct() {
        $this->data = new Container();
    }

    public function setData($key,$value=null,$useMap=true) {
        $this->data->set($key,$value,$useMap);
        return $this;
    }
    public function getData($key=null,$defaultValue=null,$useMap=true) {
        return $this->data->get($key,$defaultValue,$useMap);
    }

    public function output($array,$pretty=true) {
        $opts = 0;
        if($pretty) {
            $opts = JSON_PRETTY_PRINT;
        }
        $opts = $opts | JSON_UNESCAPED_SLASHES;
        echo json_encode($array,$opts);
    }
    public function packetSuccess() {
        return ["success"=>true,"data"=>$this->data->toArray()];
    }
    public function packetError($message=null) {
        $packet = ["success"=>false,"data"=>$this->data->toArray()];
        if(!is_null($message)) {
            $packet["message"] = $message;
        }
        return $packet;
    }

    public function isPermissed() {
        return true;
    }

    public function preHeader() {
        return;
    }
    public function header() {
        return;
    }
    public function postHeader() {
        return;
    }
    public function preProcess() {
        header("Content-Type: application/json");
        return;
    }

    public function postProcess() {
        return;
    }
    public function preFooter() {
        return;
    }
    public function footer() {
        return;
    }
    public function postFooter() {
        return;
    }    
}