<?php
namespace boru\dhfw\base;

use boru\dhfw\AppRouter;
use boru\dhfw\viewer\Viewer;

class BaseField {
    private $label = "";
    private $value = "";
    private $name = "";
    private $type = "text";
    private $options = [];
    private $required = false;
    private $cssClasses = "";
    private $elementId = "";

    private $moduleName = "";

    private $refModule = "";
    private $refIdField = "";
    private $refLabelField = "";

    private $fields = [];
    private $map = false;

    private $viewer = null;

    public function __construct($data=[]) {
        $this->setFromArray($data);
    }

    public function setFromArray($array=[],$reset=true) {
        if($reset) {
            $this->label = "";
            $this->value = "";
            $this->name = "";
            $this->type = "text";
            $this->options = [];
            $this->required = false;
            $this->cssClasses = "";
            $this->elementId = "";
            $this->moduleName = "";
            $this->refModule = "";
            $this->refIdField = "";
            $this->refLabelField = "";
            $this->fields = [];
            $this->map = false;
            $this->viewer = null;
        }
        foreach($array as $key=>$value) {
            if(method_exists($this,$key)) {
                $this->$key($value);
            }
        }
    }

    public function label($label=null) {
        if(!is_null($label)) {
            $this->label = $label;
        }
        return $this->label;
    }
    public function value($value=null) {
        if(!is_null($value)) {
            $this->value = $value;
        }
        return $this->value;
    }
    public function name($name=null) {
        if(!is_null($name)) {
            $this->name = $name;
        }
        return $this->name;
    }
    public function type($type=null) {
        if(!is_null($type)) {
            $this->type = $type;
        }
        return $this->type;
    }
    public function options($options=null) {
        if(!is_null($options)) {
            $this->options = $options;
        }
        return $this->options;
    }
    public function displayValue() {
        return $this->value();
    }
    public function required($required=null) {
        if(!is_null($required)) {
            $this->required = $required;
        }
        return $this->required;
    }
    public function cssClasses($cssClasses=null) {
        if(!is_null($cssClasses)) {
            $this->cssClasses = $cssClasses;
        }
        return $this->cssClasses;
    }
    public function elementId($elementId=null) {
        if(!is_null($elementId)) {
            $this->elementId = $elementId;
        }
        return $this->elementId;
    }
    public function moduleName($moduleName=null) {
        if(!is_null($moduleName)) {
            $this->moduleName = $moduleName;
        }
        return $this->moduleName;
    }
    public function refModule($refModule=null) {
        if(!is_null($refModule)) {
            $this->refModule = $refModule;
        }
        return $this->refModule;
    }
    public function refIdField($refIdField=null) {
        if(!is_null($refIdField)) {
            $this->refIdField = $refIdField;
        }
        return $this->refIdField;
    }
    public function refLabelField($refLabelField=null) {
        if(!is_null($refLabelField)) {
            $this->refLabelField = $refLabelField;
        }
        return $this->refLabelField;
    }
    public function map($map=null) {
        if(!is_null($map)) {
            $this->map = $map;
        }
        return $this->map;
    }
    public function viewer($viewer=null) {
        if(!is_null($viewer)) {
            $this->viewer = $viewer;
        }
        if(is_null($viewer)) {
            return Viewer::getInstance();
        }
        return $this->viewer;
    }

    public function fields($fieldDefs=null) {
        if(!is_null($fieldDefs) && is_array($fieldDefs)) {
            $this->setFields($fieldDefs);
        }
        return $this->fields;
    }
    public function setFields($fieldDefs) {
        $this->fields = [];
        $appRouter = AppRouter::getInstance();
        foreach($fieldDefs as $fieldName=>$fieldDef) {
            if($fieldDef instanceof BaseField) {
                $field = $fieldDef;
            } else {
                if(!isset($fieldDef["name"])) {
                    $fieldDef["name"] = $fieldName;
                }
                if(($field = $appRouter->fieldFromDef($fieldDef)) === false)  {
                    continue;
                }
            }
            $this->fields[$field->name()] = $field;
        }
        return $this->fields;
    }

    public function capture($appRouter) {
        $fieldName = $this->name();
        $fieldValue = $appRouter->request($fieldName,false);
        if($fieldValue !== false) {
            $this->value($fieldValue);
        }
    }

    public function display($viewType,$viewer=null) {
        if(is_null($viewer)) {
            $viewer = $this->viewer();
        }
        $viewer->displayField($this,$viewType);
    }
}