jQuery(function() {
    $(".dataTables_wrapper .dataTables_length select").css("margin-right","30px")
    $('.use-select2').select2({
        theme: 'navdark'
    });
});
$(document).ready(function(){
    //CreateButton actions
    $("body").on('click','.createRecord',function(){
        var moduleLabel = $(this).data("module");
        if(typeof moduleLabel === 'undefined' || moduleLabel == null || moduleLabel == "") {
            moduleLabel = APPMODULE;
        }
        var moduleName = moduleLabel.toLowerCase();
        var data = {};
        var prefill = getPrefillValues($(this));
        if(prefill == false) {
        } else {
            data.prefill = prefill.fields;
            data.hide = prefill.hide;
        }
        var modal = AppModal.view("/"+moduleName+"/create", "Add New "+moduleLabel,null,data);
        var cancel = modal.addButton("Cancel","btn btn-default",true);
        var button = modal.addButton("Save","btn btn-primary",false);
        button.closest("form").keypress(function(e) {
            if(e.which == 13) {
                button.click();
            }
        });
        button.on("click",function(){
            modal.find(".modalErrorMessageGroup").addClass("d-none");
            modal.find(".modalErrorMessage").html("Unknown error occured. Please try again.");
            var data = {};
            modal.find(".createField").each(function(){
                var field = $(this).attr("name");
                var val = $(this).val();
                if(val == ""){
                    if($(this).attr("required") == "required" || $(this).data("required") == true) {
                        modal.find(".modalErrorMessage").html("Please fill all the fields");
                        modal.find(".modalErrorMessageGroup").removeClass("d-none");
                        return false;
                    }
                }
                data[field] = val;
            });
    
            AppConnector.post("/"+moduleName+"/a/create",{
                data: data,
                dataType: "json"
            }).then(
                function(response) {
                    console.log('responseSuccess',response);
                    window.location.href = response.data.url;
                    modal.hide();
                },
                function(response) {
                    console.log('responseError',response);
                    modal.find(".modalErrorMessage").html(response.message);
                    modal.find(".modalErrorMessageGroup").removeClass("d-none");
                }
            );
        });
    });
    //DetailView Edit Actions
    $("body").on('click','.detailValue.editable',function(){
        var thisObject = $(this);
        var field = $(this).data('field');
        var fieldType = $(this).data('type');
        var fieldOptions = $(this).data('options');
        if(typeof fieldType === 'undefined' || fieldType == null || fieldType == "") {
            fieldType = "text";
        }
        var recordId = $('#recordId').val();
        var data = {
            field:field,
            fieldType:fieldType,
            fieldOptions:fieldOptions
        };
        $(this).on("click",function() {
            var modal = AppModal.view("/"+APPMODULE+"/"+recordId+"/fieldedit","Edit "+field,null,data);
            var cancel = modal.addButton("Cancel","btn btn-default",true);
            var button = modal.addButton("Save","btn btn-primary",false);
            button.on("click",function(){
                var data = {
                    recordId:recordId,
                    field:field,
                };
                modal.find(".editField").each(function(){
                    var field = $(this).attr("name");
                    var val = $(this).val();
                    if(val == ""){
                        if($(this).attr("required") == "required" || $(this).data("required") == true) {
                            modal.find(".modalErrorMessage").html("Please fill all the fields");
                            modal.find(".modalErrorMessageGroup").removeClass("d-none");
                            return false;
                        }
                    }
                    data[field] = val;
                });
                
                AppConnector.post("/"+APPMODULE+"/a/fieldedit",{
                    data: data,
                    dataType: "json"
                }).then(
                    function(response) {
                        console.log('responseSuccess',response);
                        if(response.success) {
                            thisObject.html(response.data.value);
                        }
                        modal.hide();
                    },
                    function(response) {
                        console.log('responseError',response);
                        modal.find(".modalErrorMessage").html(response.message);
                        modal.find(".modalErrorMessageGroup").removeClass("d-none");
                    }
                );
            });
        });
    });
    //logout link
    $("body").on('click','.logout-link',function(){
        AppModal.confirm("Confirm Logout","Are you sure you want to logout?",function(){
            AppConnector.post("/user/a/logout",{data: {},dataType: "json"}).then(function(response){
                window.location.href = APPURL + "/user/login";
            },function(response) {
                AppModal.alert("Error Logging Out","There was an error logging out. Please try again.");
            });
        });
    });
});

function getPrefillValues(field) {
    var module = field.data('module');
    var prefillClass = field.data('prefillClass');
    var data = {};
    var hide = {};
    var has = false;
    if(typeof prefillClass !== 'undefined' && prefillClass != null && prefillClass != "") {
        $("."+prefillClass).each(function() {
            has = true;
            var field = $(this).data('field');
            var value = $(this).val();
            data[field] = value;
            var hideField = $(this).data('hide');
            if(typeof hideField !== 'undefined' && hideField != null && hideField != "") {
                hide[field] = true;
            }
        });
    } else {
        $(".createRecordPrefill").each(function() {
            if($(this).data('module') == module) {
                has = true;
                var field = $(this).data('field');
                var value = $(this).val();
                data[field] = value;
            }
        });
    }
    if(has) {
        return {
            fields:data,
            hide:hide
        };
    } else {
        return false;
    }
}
