console.log('AppModal class loaded');
class AppModal {
    constructor(container = '#appModal',options = null, buttons = null) {
        if(typeof AppModal._instance === 'undefined') {
            AppModal._instance = {};
        }
        if(typeof AppModal._num === 'undefined') {
            AppModal._num = 0;
        }

        if(typeof this.previous === 'undefined') {
            this.previous = null;
        }
        this.name = container;
        this.modal = $(container);
        this.modalDialog = this.modal.find('.modal-dialog');
        this.modalBody = this.modal.find('.modal-body');
        this.modalHeader = this.modal.find('.modal-header');
        this.modalTitle = this.modal.find('.modal-title');
        this.modalDismissButton = this.modal.find('.btn-close');
        this.modalFooter = this.modal.find('.modal-footer');
        this.buttonDismiss = this.modal.find('.buttonDismiss');
        if(options == null) {
            options = { "backdrop": true, "focus": true, "keyboard": true};
        }
        this.setOptions(options);
        if(buttons == null) {
            buttons = [
                {"class": "btn btn-secondary", "dismiss": true, "text": "Close"},
                {"class": "btn btn-primary", "dismiss": false, "text": "Save"}
            ];
        }
        this.setButtons(buttons);
        if(typeof AppModal._instance[container] !== 'undefined') {
            this.appModal = AppModal._instance[container].appModal;
        } else {
            this.appModal = new bootstrap.Modal(container, this.options);
        }
        AppModal._instance[container] = this;
        AppModal._num++;
        this.setHandler();
        this.modal.data('appName',container);
    }
    setHandler() {
        this.off('hidden.bs.modal');
        this.on('hidden.bs.modal', function (e) {
            var modal = $(this);
            var appName = modal.data('appName');
            var app = AppModal.instanceByName(appName);
            let isPrevious = false;
            for(let [key,value] of Object.entries(AppModal._instance)) {
                if(value.previous != null && value.previous.name == appName) {
                    isPrevious = true;
                    break;
                }
            }
            if(!isPrevious) {
                if(app.previous != null) {
                    app.previous.show();
                }
                app.remove();
            }
        });
    }
    setButtons(buttons=null) {
        if(buttons != null) {
            this.buttons = buttons;
        }
        this.modalFooter.html('');
        for(let [key,value] of Object.entries(this.buttons)) {
            this.addButton(value.text, value.class, value.dismiss);
        }
    }
    clearButtons() {
        this.buttons = [];
        this.setButtons();
    }
    addButton(text, buttonClass="btn btn-primary", dismiss=false) {
        var dismissHtml = '';
        if(dismiss) {
            dismissHtml = " data-bs-dismiss='modal'";
        }
        var newButton = $("<button type='button' class='"+buttonClass+"'"+dismissHtml+">"+text+"</button>");
        this.modalFooter.append(newButton);
        return newButton;
    }

    setOptions(options) {
        this.options = options;
        this.appModal = new bootstrap.Modal('#appModal', this.options);
    }

    dispose() {
        this.appModal.dispose();
    }
    remove() {
        if(this.name != "#appModal" && this.modal.length > 0) {
            AppModal._instance[this.name] = null;
            this.modal.remove();
            AppModal.consolidateInstanceList();
        }
    }
    hide() {
        this.appModal.hide();
    }
    show() {
        if(AppModal.anyShowing() && AppModal.anyShowing() != this.name) {
            this.previous = AppModal.instanceByName(AppModal.anyShowing());
            this.previous.hide();   
        }
        this.appModal.show();
    }
    
    xlarge() {
        this.modalDialog.removeClass('modal-sm modal-md modal-lg modal-xl');
        this.modalDialog.addClass('modal-xl');
    }
    large() {
        this.modalDialog.removeClass('modal-sm modal-md modal-lg modal-xl');
        this.modalDialog.addClass('modal-lg');
    }
    medium() {
        this.modalDialog.removeClass('modal-sm modal-md modal-lg modal-xl');
        this.modalDialog.addClass('modal-md');
    }
    small() {
        this.modalDialog.removeClass('modal-sm modal-md modal-lg modal-xl');
        this.modalDialog.addClass('modal-sm');
    }
    reset() {
        this.modalDialog.removeClass('modal-sm modal-md modal-lg modal-xl');
    }
    setTitle(title) {
        this.modalTitle.html(title);
    }
    setBody(body) {
        this.modalBody.html(body);
    }
    setFooter(footer) {
        this.modalFooter.html(footer);
    }
    setHeader(header) {
        this.modalHeader.html(header);
    }
    isShowing() {
        return this.modal.is(':visible');
    }

    /*
     * JQuery Pass-through methods
    */
    on(event, callback) {
        this.modal.on(event, callback);
    }
    off(event) {
        this.modal.off(event);
    }
    trigger(event) {
        this.modal.trigger(event);
    }
    find(selector) {
        return this.modal.find(selector);
    }
    /*
     * Static methods
     */

    static anyShowing() {
        AppModal.consolidateInstanceList();
        for(let [key,value] of Object.entries(AppModal._instance)) {
            if(value) {
                if(typeof value.modal != "undefined" && value.modal.is(':visible')) {
                    return key;
                }
            }
        }
        return false;
    }
    static view(viewUrl,title=null,callback=null,data=null) {
        var appModal = AppModal.create({
            "title": title,
            "body": "Loading ...",
            "options": {
                "backdrop": "static",
                "keyboard": false
            },
            "buttons": []
        });
        if(typeof data === 'undefined' || data == null) {
            data = {};
        }
        data.isModal = true;
        AppConnector.post(viewUrl, {
            "data": data,
            "dataType": "html",
            "success": function (data) {
                appModal.setBody(data);
                if (callback != null) {
                    callback();
                }
                appModal.show();
            }
        });
        return appModal;
    }
    static notice(title, body, callback=null) {
        var appModal = AppModal.create({
            "title": title,
            "body": body,
            "options": {
                "backdrop": true,
                "keyboard": true,
            },
            "buttons": [
                {"class": "btn btn-primary", "dismiss": true, "text": "OK"}
            ]
        });
        if(callback != null) {
            appModal.modal.on('hidden.bs.modal', function (e) {
                callback();
            });
        }
        appModal.show();
        return appModal;
    }
    static alert(title, body, callback=null) {
        var appModal = AppModal.create({
            "title": title,
            "body": body,
            "options": {
                "backdrop": "static",
                "keyboard": false,
            },
            "buttons": [
                {"class": "btn btn-primary", "dismiss": true, "text": "OK"}
            ]
        });
        if(callback != null) {
            appModal.modal.on('hidden.bs.modal', function (e) {
                callback();
            });
        }
        appModal.modalDismissButton.hide();
        appModal.show();
        return appModal;
    }

    static confirm(title, body, callback=null, cancelButton=true) {
        if(cancelButton) {
            var buttons = [
                {"class": "btn btn-secondary", "dismiss": true, "text": "Cancel"},
                {"class": "btn btn-primary appModal-confirm", "dismiss": false, "text": "Confirm"}
            ];
        } else {
            var buttons = [
                {"class": "btn btn-primary appModal-confirm", "dismiss": false, "text": "Confirm"}
            ];
        }
        var appModal = AppModal.create({
            "title": title,
            "body": body,
            "options": {
                "backdrop": "static",
                "keyboard": false,
            },
            "buttons": buttons
        });
        if(!cancelButton) {
            appModal.modalDismissButton.hide();
        }
        appModal.modal.on('click', '.appModal-confirm', function (e) {
            if(callback != null) {
                callback(appModal);
            } else {
                appModal.hide();
            }
        });
        appModal.show();
        return appModal;
    }
    static create(opts=null) {
        if(opts == null) {
            opts = {};
        }
        if(typeof AppModal._num === 'undefined') {
            AppModal._num = 0;
        }
        if($("#appModal").length) {
            var newModal = $("#appModal").clone();
            newModal.attr("id","appModal--"+AppModal._num);
            newModal.appendTo($("body"));
            var options = null;
            if(typeof opts.options !== "undefined") {
                options = opts.options;
            }
            var buttons = null;
            if(typeof opts.buttons !== "undefined") {
                buttons = opts.buttons;
            }

            var modal = new AppModal("#appModal--"+AppModal._num, options, buttons);
            if(typeof opts.title !== 'undefined') {
                modal.setTitle(opts.title);
            }
            if(typeof opts.body !== 'undefined') {
                modal.setBody(opts.body);
            }
            if(typeof opts.footer !== 'undefined') {
                modal.setFooter(opts.footer);
            }
            if(typeof opts.header !== 'undefined') {
                modal.setHeader(opts.header);
            }
            if(typeof opts.size !== 'undefined') {
                modal[opts.size]();
            }
            if(typeof opts.show !== 'undefined') {
                modal.show();
            }
            if(typeof opts.hide !== 'undefined') {
                modal.hide();
            }
            
            AppModal._instance[modal.name] = modal;
            return modal;
        }
        return false;
    }
    static instanceByName(name) {
        if(typeof AppModal._instance[name] !== 'undefined') {
            return AppModal._instance[name];
        }
        return false;
    }
    static consolidateInstanceList() {
        let instances = {};
        for(let [key,value] of Object.entries(AppModal._instance)) {
            if(value) {
                if(typeof value.modal != "undefined") {
                    instances[key] = value;
                }
            }
        }
        AppModal._instance = instances;
    }
}