<?php
namespace boru\dhfw\app\basemodule\views;

class ExceptionView extends View {
    private $trace;
    private $exception;

    protected $requiresAuth = false;

    public function setException($exception) {
        $this->exception = $exception;
    }
    public function init() {
        
    }
    public function process() {
        if(!is_null($this->exception) && $this->exception instanceof \Exception) {
            $this->viewer->assign("message",$this->exception->getMessage());
            $this->viewer->assign("code",$this->exception->getCode() > 0 ? $this->exception->getCode() : 500);
            $this->viewer->assign("trace",static::parseTrace($this->exception->getTrace()));
        } else {
            $this->viewer->assign("message","Unknown Exception");
            $this->viewer->assign("code",500);
            $this->viewer->assign("trace",[]);
        }
        
        $this->viewer->display("Exception.tpl");
    }
    private static function parseTrace($trace) {
        $output = [];
        foreach($trace as $line) {
            $output[] = static::getTraceEntry($line);
        }
        return $output;
    }
    private static function getTraceInfo($stepsToDiscard=2) {
        $trace = debug_backtrace();
        while($stepsToDiscard-- > 0) {
            array_shift($trace);
        }
        foreach($trace as $line) {
            $output[] = static::getTraceEntry($line);
        }
        return $output;
    }
    private static function getTraceEntry($traceEntry) {
        $trace = [
            "file"=>$traceEntry['file'],
            "line"=>$traceEntry['line'],
            "func"=>$traceEntry['function'],
            "args"=>$traceEntry['args'],
        ];
        //if the trace has a classname, append it to the function name
        if(isset($traceEntry['class'])) {
            $trace["func"] = $traceEntry['class'] . "::" . $traceEntry['function'];
        }
        return $trace;
    }
}