<?php
namespace boru\dhfw\base;

use boru\dhfw\app\basemodule\fields\Field;
use boru\dhfw\AppRouter;
use boru\dhfw\DHFW;
use boru\dhfw\util\Container;
use boru\dhfw\util\Debug;
use boru\dhfw\util\QueryConditions;
use boru\dhutils\dhGlobal;
use boru\dhutils\filesys\Directory;
use ReflectionClass;

abstract class BaseModule extends BaseModuleRecord {

    //all of these variables are commented and defined in BaseModuleRecord
    protected static $moduleName = "Module";
    protected static $isRecordModule = true;
    protected static $sqlTable = "";
    protected static $sqlExtraTables = [];
    protected static $sqlTableJoins = [];
    protected static $idField = "";
    protected static $createdTimeField = "";
    protected static $modifiedTimeField = "";
    protected static $labelField = "";

    protected static $jsonFields = [];
    protected static $serializedFields = [];

    protected static $fieldDefs = [];

    
    protected static $Static_SQLDebug = false;
    /**
     * The default view to use for this module
     * @var string
     */
    protected static $defaultView = "Home";

    public static function initDefaults() {
        if(static::$isRecordModule) {
            static::initSqlDefaults();
        }
    }

    public static function getDefaultViewName() {
        return static::$defaultView;
    }

    public static function setSqlDebug($debug) {
        static::$Static_SQLDebug = $debug;
    }

    public static function getModuleName() {
        return static::$moduleName;
    }

    /**
	 * 
	 * @param string $field 
	 * @param string $value 
	 * @param int $offset 
	 * @param int $limit 
	 * @param string $orderby 
	 * @param string $orderdir 
	 * @param string $groupby 
	 * @param string $comparator 
	 * @return false|static[] 
	 */
	public static function search($field="",$value="",$offset=0,$limit=0,$orderby="",$orderdir="",$groupby="",$comparator="eq") {
	    $db = DHFW::db();
		$sql = "SELECT * FROM ";
        $sql.= static::SQLTableWithJoins();
        $values = [];
        if($field instanceof QueryConditions) {
            $whereConditions = $field;
        } else {
            $whereConditions = new QueryConditions();
            if(is_array($field) || !empty($field)) {
                if(is_array($field)) {
                    $whereConditions->addArray($field);
                } else {
                    $whereConditions->add($field,$value,$comparator);
                }
                $sql.=" ".$whereConditions->getSQL("WHERE");
                $values = $whereConditions->getValues();
            } else {
                
            }
        }
		if($orderby != "") {
			$sql.=" ORDER BY $orderby $orderdir";
		}
		if($limit>=1) {
			$sql.=" LIMIT ?,?";
			$values[] = $offset;
			$values[] = $limit;
		}
        if(static::$Static_SQLDebug) {
            dhGlobal::outLine("SQLDebug(static)",$sql,"::::",$values);
        }
		$sth=$db->run($sql,$values);
		$return = array();
		while($row=$db->next($sth)) {
			$obj = new static();
			$obj->populate($row->toArray());
			$return[] = $obj;
		}
		if(empty($return)) return false;
		return $return;
	}

    /**
	 * 
	 * @param mixed $field 
	 * @param int $offset 
	 * @param int $limit 
	 * @param string $orderby 
	 * @param string $orderdir 
	 * @return false|array 
	 */
	public static function searchDistinct($field,$offset=0,$limit=0,$orderby="",$orderdir="") {
		$db = DHFW::db();
		$sql = "select DISTINCT `".$field."` FROM ";
        $sql.= static::SQLTableWithJoins();
		$values = array();
		if($limit>=1) {
			$sql.=" LIMIT ?,?";
			$values[] = $offset;
			$values[] = $limit;
		}
		if($orderby != "") {
			$sql.=" ORDER BY $orderby $orderdir";
		}
        if(static::$Static_SQLDebug) {
            dhGlobal::outLine("SQLDebug(static)",$sql,"::::",$values);
        }
		$sth=$db->run($sql,$values);
		$return = array();
		while($row=$db->next($sth)) {
			$return[] = $row[$field];
		}
		if(empty($return)) return false;
		return $return;
	}

    /**
	 * 
	 * @param mixed $field 
	 * @param string $value 
	 * @param string $comparator 
	 * @return false|static 
	 */
	public static function getOne($field,$value="",$comparator="eq") {
		$data = static::search($field,$value,0,1,"","","",$comparator);
		if(empty($data)) return false;
		return $data[0];
	}

	/**
	 * 
	 * @param array $array 
	 * @return static 
	 */
	public static function create($array=array()) {
		global $dbh;
		$obj = new static();
		if(!empty($array)) {
			$obj->populate($array);
			$obj->save(true);
			$obj->setNew(true);
		}
		return $obj;
	}

    /**
	 * 
	 * @param mixed $array 
	 * @param string $comparator 
	 * @return static 
	 */
	public static function getOrCreate($array,$comparator="eq") {
		$data = static::getOne($array,"",$comparator);
		if(!$data) {
			$data = static::create();
			$data->populate($array);
			$data->save(true);
			$data->setNew(true);
		}
		return $data;
	}

    /**
	 * 
	 * @param mixed $value 
	 * @return false|static 
	 */
	public static function getById($value) {
		return static::getOne(static::$idField,$value,"eq");
	}

    private $debugSql = false;
    protected $id;
    protected $data;
    protected $isNew;
    protected $fields = [];
    public function get($key=null,$default=null) {
        return $this->data->get($key,$default);
    }
    public function set($key,$value) {
        $this->data->set($key,$value);
    }
    public function setNew($new) {
        $this->isNew = $new;
    }
    public function isNew() {
        return $this->isNew;
    }
    public function setId($id) {
        $this->id = $id;
    }
    public function id() {
        return $this->id;
    }
    public function moduleName() {
        return static::$moduleName;
    }
    public function debugSql($debug=true) {
        $this->debugSql = $debug;
    }
    /**
     * @param mixed $fieldName 
     * @return Field[] 
     */
    public function fields() {
        return $this->fields;
    }
    /**
     * @param mixed $fieldName 
     * @return Field|false 
     */
    public function field($fieldName) {
        if(isset($this->fields[$fieldName])) {
            return $this->fields[$fieldName];
        }
        return false;
    }

    public function __construct() {
        static::initDefaults();
        $this->data = new Container();
    }

    public function delete() {
        $this->_delete();
    }
    public function _delete() {
        $db = DHFW::db();
        $sql = "DELETE FROM ".static::$sqlTable." WHERE ".static::$idField." = ?";
        $db->run($sql,[$this->id()]);
    }

    //Overridable save action
	public function save($date=true) {
		$this->_save($date);
		return $this;
	}
    public function _save($date=true,$forceId=false,$reload=true) {
        $db = DHFW::db();
        $data = $this->data->get();
        foreach($data as $k=>$v) {
            if($v === null) {
                unset($data[$k]);
            }
            if(is_array($v) || is_object($v)) {
                if(in_array($k,static::$jsonFields)) {
                    $data[$k] = json_encode($v,JSON_UNESCAPED_SLASHES);
                } elseif(in_array($k,static::$serializedFields)) {
                    $data[$k] = serialize($v);
                }
            }
        }

        if($this->isNew() && !$forceId) {
            $sqlInfo = static::SQLInsertQuery($data,$date);
            if($this->debugSql) {
                dhGlobal::outLine("SQLDebug(record)",$sqlInfo["sql"],"::::",$sqlInfo["values"]);
            }
            $db->run($sqlInfo["sql"],$sqlInfo["values"]);
            $this->setId($db->lastInsertId());
            $this->setNew(false);
        } else {
            $whereConditions = [static::$idField=>$this->id()];
            $sqlInfo = static::SQLUpdateQuery($data,$whereConditions,$date);
            if($this->debugSql) {
                dhGlobal::outLine("SQLDebug(record)",$sqlInfo["sql"],"::::",$sqlInfo["values"]);
            }
            $db->run($sqlInfo["sql"],$sqlInfo["values"]);
        }
        if($this->id()) {
            if($reload) {
                $this->load($this->id(),true);
            }
            return true;
        }
        return false;
    }

    public function populate($data) {
        $idField = static::$idField;
        if(isset($data[$idField])) {
            $this->setId($data[$idField]);
        }
        
        foreach($data as $k=>$v) {
            if(in_array($k,static::$jsonFields) && !is_array($v) && !is_object($v)) {
                $v = json_decode($v,true);
            } elseif(in_array($k,static::$serializedFields) && !is_array($v) && !is_object($v)) {
                $v = unserialize($v);
            }
            $this->set($k,$v);
        }
        $this->initFields();
    }

    public function load($id,$isReload=false) {
        $data = static::getById($id);
        if(!$data) return false;
        $this->populate($data->get());
        $this->setId($id);
        if(!$isReload) {
            $this->setNew(false);
        }
        return true;
    }

    private function initFields() {
        $this->fields = static::moduleFields();
        if(!is_array($this->fields)) {
            echo static::$moduleName."::moduleFields() did not return an array";
        }
        foreach($this->fields as $fieldName=>$field) {
            if(($value = $this->get($field->name(),"ZfwZ-NO-VALUE-SET-YfwY")) !== "ZfwZ-NO-VALUE-SET-YfwY") {
                $field->value($value);
            }
            $this->fields[$field->name()] = $field;
        }
    }
    private static $moduleFieldsCache = [];
    public static function moduleFields() {
        if(isset(self::$moduleFieldsCache[static::$moduleName])) {
            return self::$moduleFieldsCache[static::$moduleName];
        }
        $appRouter = AppRouter::getInstance();
        $fields = [];
        //$appRouter::$searchClassDebug = true;
        foreach(static::$fieldDefs as $fieldName=>$fieldDef) {
            if(!isset($fieldDef["name"])) {
                $fieldDef["name"] = $fieldName;
            }
            if(($field = $appRouter->fieldFromDef($fieldDef)) !== false)  {
                $field->moduleName(static::$moduleName);
                $fields[$field->name()] = $field;
            }
        }
        //$appRouter::$searchClassDebug = false;
        self::$moduleFieldsCache[self::$moduleName] = $fields;
        return $fields;
    }
}