<?php
namespace boru\dhfw\app\basemodule\fields;

use boru\dhfw\AppRouter;

class RefField extends Field {
    public function __construct($data=[]) {
        $data["type"] = "ref";
        parent::__construct($data);
        $this->addCssClass("form-control");

        if(!isset($data["options"])) {
            $options = [];

            if(!$this->required()) {
                $options[""] = "-None-";
            }

            $appRouter = AppRouter::getInstance();
            $module = $appRouter->getmodule($this->refModule());
            $records = $module::search();
            $labelField = $this->refLabelField();
            $idField = $this->refIdField();
            foreach($records as $record) {
                $options[$record->get($idField)] = $record->get($labelField);
            }
            $this->options($options);
        }
    }
    public function displayValue() {
        $appRouter = AppRouter::getInstance();
        $module = $appRouter->getmodule($this->refModule());
        $record = $module::getById($this->value());
        if($record) {
            $labelField = $this->refLabelField();
            return $record->get($labelField);
        } else {
            return "";
        }
    }
}