<?php
namespace boru\dhfw\app\basemodule\actions;

class CreateAction extends Action {
    protected $requiresAuth = true;
    
    public function process() {
        $module = $this->module();
        $prefix = $this->request("prefix","pw__");
        $array = [];
        foreach($module::moduleFields() as $field) {
            $field->capture($this->appRouter,$prefix);
            if($field->value() !== "") {
                $array[$field->name()] = $field->value();
            }
        }
        if(empty($array)) {
            foreach($module::moduleFields() as $field) {
                $field->capture($this->appRouter);
                $array[$field->name()] = $field->value();
            }   
        }

        if(!empty($array)) {
            $record = $module::create($array);
            $record->save();
            $this->set("id",$record->get('id'));
            $this->set("label",$record->label());
            $this->set("type",strtolower($record->getModuleName()));
            $this->set("url",$this->viewer->viewUrl($module::getModuleName(),"detail",$record->id()));
            $this->set("success",true);
            $this->output($this->packetSuccess(),true);
            return;
        } else {
            echo json_encode($this->packetError("No data received"),JSON_PRETTY_PRINT|JSON_UNESCAPED_SLASHES);
            return;
        }
    }
}