<?php
namespace boru\dhfw\app\basemodule\actions;

class SaveAction extends \boru\dhfw\app\basemodule\actions\Action {
    /** @var \boru\dhfw\app\basemodule\Module|false */
    private $moduleRecord;

    public function init() {
        parent::init();
        $module = $this->module();
        if($this->recordId()) {
            $this->moduleRecord = $module::getById($this->recordId());
        } else {
            $this->moduleRecord = false;
        }        
    }
    public function process() {

        if(!$this->moduleRecord) {
            $this->set("success",false);
            $this->set("message","Invalid record id");
            $this->output($this->packetSuccess(),true);
        }

        $prefix = $this->request("prefix","pw__");
        $withPrefix = false;
        foreach($this->getAll() as $key=>$value) {
            if(substr($key,0,strlen($prefix)) == $prefix) {
                $key = substr($key,strlen($prefix));
                $this->moduleRecord->set($key,$value);
                $withPrefix=true;
            }
        }
        if(!$withPrefix) {
            foreach($this->getAll() as $key=>$value) {
                $this->moduleRecord->set($key,$value);
            }
        }
        $this->moduleRecord->save();
        
        $this->set("id",$this->moduleRecord->id());
        $this->set("label",$this->moduleRecord->label());
        $this->set("type",strtolower($this->moduleRecord->getModuleName()));
        $this->set("url",$this->viewer->viewUrl($this->moduleRecord::getModuleName(),"detail",$this->moduleRecord->id()));
        $this->set("success",true);
        $this->output($this->packetSuccess(),true);
        return;
    }
}