<?php
namespace boru\dhfw\app\basemodule\views;

class ListView extends View {
    public function init() {
        parent::init();
    }

    private $records = [];
    public function process() {
        $module = $this->module();
        $searchString = $this->getVar("rest","");
        
        $fields = $module::moduleFields();
        $listFields = [];
        $listRecords = [];
        foreach($fields as $fieldName=>$field) {
            if($field->listable()) {
                $listFields[$fieldName] = $field;
            }
        }
        /*if(is_array($this->records)) {
            foreach($this->records as $record) {
                $listRecord = [];       
                foreach($listFields as $fieldName=>$field) {
                    $listRecord[$fieldName] = clone $field;
                    $listRecord[$fieldName]->value($record->get($fieldName));
                }
                $listRecords[$record->id()] = $listRecord;
            }
        }*/
        $this->viewer->assign("labelField",$module::labelField());
        $this->viewer->assign("listSearch",$searchString);
        $this->viewer->assign("listFields",$listFields);
        $this->viewer->assign("listRecords",$listRecords);
        $this->viewer->assign("records",$this->records);

        $ajaxData = [
            "module"=>$module->getModuleName(),
            "fields"=>array_keys($listFields),
            "searchString"=>$this->getVar("rest",""),
            "perPage"=>$this->get("perPage",20),
            "page"=>$this->get("page",1),
            "orderBy"=>$this->get("orderBy","id desc"),
        ];
        $this->viewer->assign("listSearchData",htmlentities(json_encode($ajaxData,JSON_UNESCAPED_SLASHES|JSON_UNESCAPED_UNICODE), ENT_QUOTES, 'UTF-8'));

        $this->viewer->display("ListView.tpl");
    }

    public function setRecords($records) {
        $this->records = $records;
    }
}