<?php
namespace boru\dhfw\base;

use boru\dhfw\AppRouter;
use boru\dhfw\viewer\Viewer;

class BaseField implements \JsonSerializable{
    private $label = "";
    private $value = "";
    private $name = "";
    private $type = "text";
    private $options = [];
    private $required = false;
    private $hidden = false;
    private $editable = true;
    private $listable = true;
    private $listorder = 0;
    private $detailorder = 0;

    private $cssClasses = "";
    private $elementId = "";

    private $moduleName = "";

    private $refModule = "";
    private $refIdField = "";
    private $refLabelField = "";

    private $derivedCallable = false;

    private $fields = [];
    private $map = false;

    private $baseType = "text";

    private $viewer = null;

    public function __construct($data=[]) {
        $this->setFromArray($data);
    }

    public function setFromArray($array=[],$reset=true) {
        if($reset) {
            $this->label = "";
            $this->value = "";
            $this->name = "";
            $this->type = "text";
            $this->options = [];
            $this->required = false;
            $this->hidden = false;
            $this->cssClasses = "";
            $this->elementId = "";
            $this->moduleName = "";
            $this->refModule = "";
            $this->refIdField = "";
            $this->refLabelField = "";
            $this->derivedCallable = false;
            $this->fields = [];
            $this->map = false;
            $this->viewer = null;
        }
        foreach($array as $key=>$value) {
            if($key == "subfields" && !empty($value)) {
                $arr = json_decode($value,true);
                if(!empty($arr)) {
                    $this->setFields($arr);
                }
            } elseif($key == "references" && !empty($value)) {
                $arr = json_decode($value,true);
                foreach($arr as $refKey=>$refValue) {
                    if(method_exists($this,$refKey)) {
                        $this->$refKey($refValue);
                    }
                }
            } else {
                if(method_exists($this,$key)) {
                    $this->$key($value);
                }
            }
        }
    }

    public function baseType($baseType=null) {
        if(!is_null($baseType)) {
            $this->baseType = $baseType;
        }
        return $this->baseType;
    }

    public function label($label=null) {
        if(!is_null($label)) {
            $this->label = $label;
        }
        return $this->label;
    }
    public function value($value=null) {
        if(!is_null($value)) {
            $this->value = $value;
        }
        return $this->value;
    }
    public function name($name=null) {
        if(!is_null($name)) {
            $this->name = $name;
        }
        return $this->name;
    }
    public function type($type=null) {
        if(!is_null($type)) {
            $this->type = $type;
        }
        return $this->type;
    }
    public function options($options=null) {
        if(!is_null($options)) {
            if(!is_array($options)) {
                $options = json_decode($options,true);
                if(!is_array($options)) {
                    $options = [];
                }
            }
            $this->options = $options;
        }
        return $this->options;
    }
    public function displayValue() {
        return $this->value();
    }
    public function required($required=null) {
        if(!is_null($required)) {
            $this->required = $required;
        }
        return $this->required;
    }
    public function hidden($hidden=null) {
        if(!is_null($hidden)) {
            $this->hidden = $hidden;
        }
        return $this->hidden;
    }
    public function editable($editable=null) {
        if(!is_null($editable)) {
            $this->editable = $editable;
        }
        return $this->editable;
    }
    public function listable($listable=null) {
        if(!is_null($listable)) {
            $this->listable = $listable;
        }
        return $this->listable;
    }
    public function listorder($listorder=null) {
        if(!is_null($listorder)) {
            $this->listorder = $listorder;
        }
        return $this->listorder;
    }
    public function detailorder($detailorder=null) {
        if(!is_null($detailorder)) {
            $this->detailorder = $detailorder;
        }
        return $this->detailorder;
    }
    public function cssClasses($cssClasses=null) {
        if(!is_null($cssClasses)) {
            $this->cssClasses = $cssClasses;
        }
        return $this->cssClasses;
    }
    public function elementId($elementId=null) {
        if(!is_null($elementId)) {
            $this->elementId = $elementId;
        }
        return $this->elementId;
    }
    public function moduleName($moduleName=null) {
        if(!is_null($moduleName)) {
            $this->moduleName = $moduleName;
        }
        return $this->moduleName;
    }
    public function refModule($refModule=null) {
        if(!is_null($refModule)) {
            $this->refModule = $refModule;
        }
        return $this->refModule;
    }
    public function refIdField($refIdField=null) {
        if(!is_null($refIdField)) {
            $this->refIdField = $refIdField;
        }
        return $this->refIdField;
    }
    public function refLabelField($refLabelField=null) {
        if(!is_null($refLabelField)) {
            $this->refLabelField = $refLabelField;
        }
        return $this->refLabelField;
    }
    public function derivedCallable($derivedCallable=null) {
        if(!is_null($derivedCallable)) {
            if($derivedCallable == "none") {
                $derivedCallable = false;
            }
            $this->derivedCallable = $derivedCallable;
        }
        return $this->derivedCallable;
    }
    public function map($map=null) {
        if(!is_null($map)) {
            $this->map = $map;
        }
        return $this->map;
    }
    public function viewer($viewer=null) {
        if(!is_null($viewer)) {
            $this->viewer = $viewer;
        }
        if(is_null($viewer)) {
            return Viewer::getInstance();
        }
        return $this->viewer;
    }

    public function addCssClass($cssClass) {
        //only add if not already present
        if(strpos($this->cssClasses,$cssClass)===false) {
            if($this->cssClasses != "") {
                $this->cssClasses .= " ";
            }
            $this->cssClasses .= $cssClass;
        }
        return $this->cssClasses;
    }

    public function fields($fieldDefs=null) {
        if(!is_null($fieldDefs) && is_array($fieldDefs)) {
            $this->setFields($fieldDefs);
        }
        return $this->fields;
    }
    public function setFields($fieldDefs) {
        $this->fields = [];
        $appRouter = AppRouter::getInstance();
        $moduleName = $this->moduleName();
        foreach($fieldDefs as $fieldName=>$fieldDef) {
            if($fieldDef instanceof BaseField) {
                $field = $fieldDef;
            } else {
                if(!isset($fieldDef["name"])) {
                    $fieldDef["name"] = $fieldName;
                }
                if(($field = AppRouter::fieldFromDef($moduleName,$fieldDef)) === false)  {
                    continue;
                }
            }
            $this->fields[$field->name()] = $field;
        }
        return $this->fields;
    }

    public function capture($appRouter,$prefix="") {
        $fieldName = $this->name();
        $fieldValue = $appRouter->request($prefix.$fieldName,false);
        if($fieldValue !== false) {
            $this->value($fieldValue);
        }
    }

    public function display($viewType,$viewer=null) {
        if(is_null($viewer)) {
            $viewer = $this->viewer();
        }
        $viewer->displayField($this,$viewType);
    }

    private $scope = "";
    private $table;

    public function getScope() {
        return $this->scope;
    }
    public function setScope($scope) {
        $this->scope = $scope;
    }

    public function getTable() {
        return $this->table;
    }
    public function setTable($table) {
        $this->table = $table;
        $this->setScope($table->alias());
    }
    public function table($escaped=true) {
        return $this->table->alias($escaped);
    }
    public function getQueryReference() {
        return $this->table().".`".$this->name()."`";
    }
    public function toArray($withValue = false) {
        $return = [];
        $return["label"] = $this->label();
        if($withValue) {
            $return["value"] = $this->value();
        }
        $return["name"] = $this->name();
        $return["type"] = $this->type();
        $return["options"] = $this->options();
        $return["required"] = $this->required();
        $return["hidden"] = $this->hidden();
        $return["editable"] = $this->editable();
        $return["listable"] = $this->listable();
        $return["refModule"] = $this->refModule();
        $return["refIdField"] = $this->refIdField();
        $return["refLabelField"] = $this->refLabelField();
        $return["derivedCallable"] = $this->derivedCallable();
        $return["fields"] = $this->fields();
        $return["map"] = $this->map();
        return $return;
    }
    public function jsonSerialize() {
        return $this->toArray();
    }
    public function __toString() {
        return $this->value();
    }
}