<?php
namespace boru\dhfw\util;

use boru\dhfw\DHFW;
use boru\dhutils\filesys\Directory;

if(!class_exists("Smarty")) {
    require_once(__DIR__."/../../lib/smarty-3.1.48/libs/Smarty.class.php");
}

class FWSmarty {
    /** @var \Smarty */
    private static $smartyObj;

    private static $options = [
        "templateDir" => "{fw}",
        "configDir" => "{fw}/smarty/config",
        "compileDir" => "{fw}/smarty/compiled",
        "cacheDir" => "{fw}/smarty/cache",
        "pluginDir" => "{fw}/smarty/plugins",
        "caching" => \Smarty::CACHING_OFF,
        "forceCompile" => false,
        "compileCheck" => true,
    ];
    public static function createInstance($options=[]) {
        static::applyOptions($options);

        if(!is_dir(static::cacheDir())) {
            Directory::fromPathString(static::cacheDir(),true,["scan" => false]);
        }
        if(!is_dir(static::compileDir())) {
            Directory::fromPathString(static::compileDir(),true,["scan" => false]);
        }
        if(!is_dir(static::configDir())) {
            Directory::fromPathString(static::configDir(),true,["scan" => false]);
        }
        if(!is_dir(static::pluginDir())) {
            Directory::fromPathString(static::pluginDir(),true,["scan" => false]);
        }
        if(!is_writable(static::cacheDir()) || !is_writable(static::compileDir())) {
            try {
                chmod(static::cacheDir(),0777);
                chmod(static::compileDir(),0777);
            } catch(\Exception $e) {
                throw new \Exception("Cache and compile directories must be writable: ".static::cacheDir()." and ".static::compileDir());
            }
            if(!is_writable(static::cacheDir()) || !is_writable(static::compileDir())) {
                throw new \Exception("Cache and compile directories must be writable: ".static::cacheDir()." and ".static::compileDir());
            }
        }
        $smarty = new \Smarty();
        $smarty->setTemplateDir(    static::templateDir() );
        $smarty->setConfigDir(      static::configDir()   );
        $smarty->setCompileDir(     static::compileDir()  );
        $smarty->setCacheDir(       static::cacheDir()    );
        $smarty->addPluginsDir(     static::pluginDir()   );
        $smarty->caching  =         static::$options["caching"];
        $smarty->compile_check =    static::$options["compileCheck"];
        $smarty->force_compile =    static::$options["forceCompile"];
        static::$smartyObj = $smarty;
    }
    public static function instance($force=false) {
        if(!class_exists("Smarty")) {
            require_once(__DIR__."/../../lib/smarty-3.1.48/libs/Smarty.class.php");
        }
        if(is_null(static::$smartyObj) || $force) {
            static::createInstance();
        }
        return static::$smartyObj;
    }
    public static function templateDir() {
        return static::applyFwDir(static::$options["templateDir"]);
    }
    public static function configDir() {
        return static::applyFwDir(static::$options["configDir"]);
    }
    public static function compileDir() {
        return static::applyFwDir(static::$options["compileDir"]);
    }
    public static function cacheDir() {
        return static::applyFwDir(static::$options["cacheDir"]);
    }
    public static function pluginDir() {
        return static::applyFwDir(static::$options["pluginDir"]);
    }
    public static function setOption($key,$value) {
        static::$options[$key] = $value;
    }
    public static function applyOptions($options) {
        if(is_array($options) && !empty($options )) {
            foreach($options as $key=>$value) {
                if(isset(static::$options[$key])) {
                    static::$options[$key] = $value;
                }
            }
        }
    }
    private static function applyFwDir($path) {
        return str_replace("{fw}",DHFW::dir(),$path);
    }
}
