<?php
namespace boru\dhfw\app\fw\actions;

class FieldeditAction extends Action {
    private $moduleRecord;
    protected $requiresAuth = true;
    
    public function process() {
        $module = $this->module();
        $moduleRecord = $module::getById($this->request("recordId"));

        $fieldName = $this->request("field");
        if(($field = $moduleRecord->field($fieldName)) !== false) {
            $field->capture($this->appRouter);
            $fieldValue = $field->value();
            $moduleRecord->set($fieldName,$fieldValue);
            $moduleRecord->save();
            $moduleRecord = $module::getById($this->request("recordId"));
            $field = $moduleRecord->field($fieldName);
            $this->set("message","Success");
            $this->set('field',$fieldName);
            $this->set("value",$field->displayValue());
            echo json_encode($this->packetSuccess(),JSON_PRETTY_PRINT|JSON_UNESCAPED_SLASHES);
            return;
        } else {
            $this->set("message","Field not found");
            echo json_encode($this->packetError(),JSON_PRETTY_PRINT|JSON_UNESCAPED_SLASHES);
            return;
        }
    }
}