<?php
namespace boru\dhfw\app\fw\actions;

use boru\dhfw\DHFW;
use boru\dhfw\base\BaseModule;
use boru\dhfw\util\QueryBuilder;

class SearchAction extends Action {

    protected $perPage = 20;
    protected $offset = 0;
    protected $orderBy = "id DESC";
    protected $groupBy = false;
    protected $search = [];
    protected $columns = [];
    protected $fields = [];

    /** @var QueryBuilder */
    private $queryBuilder;

    /** @var BaseModule[] */
    private $records;

    /** @var BaseModule */
    private $module;
    public function init() {
        $this->displayHeader = false;
        $this->displayFooter = false;
        $this->module = $this->module();
        $moduleName = $this->get("module",$this->module->getModuleName());
        if($moduleName != $this->module->getModuleName()) {
            $this->module = DHFW::getModuleClass($moduleName);
        }
    }

    public function preProcess() {
        parent::preProcess();
        //parse the request to get the search options -- perPage, orderBy, groupBy, etc..
        $this->perPage = intval($this->get("perPage",$this->perPage));
        $this->orderBy = $this->get("orderBy",$this->orderBy);
        $this->groupBy = $this->get("groupBy",$this->groupBy);
        $this->search  = $this->get("search",$this->search);
        if(!is_array($this->search)) {
            $this->search = explode(",",$this->search);
        }
        $this->columns = $this->get("columns",$this->columns);
        if($this->get("page",0)>0) {
            $this->offset = intval(($this->get("page",1)-1)*$this->perPage);
        } elseif($this->get("offset",0)>0) {
            $this->offset = intval($this->get("offset",0));
        }
    }

    public function process() {
        $this->queryBuilder = $this->module::queryBuilder();
        $this->executeSearch();
        $this->set("perPage",$this->perPage);
        $this->set("offset",$this->offset);
        $this->set("orderBy",$this->orderBy);
        $this->set("groupBy",$this->groupBy);


        $this->cleanColumns();
        $listRecords = [];
        if(is_array($this->records)) {
            foreach($this->records as $record) {
                $listRecord = [];       
                foreach($this->fields as $fieldName=>$field) {
                    $listRecord[$fieldName] = $record->field($fieldName)->value();
                }
                $listRecords[$record->id()] = $listRecord;
            }
        }
        $this->set("fields",$this->fields);
        $this->set("records",$listRecords);

        $this->output($this->packetSuccess());
        
    }

    private function executeSearch() {
        $this->parseSearch();
        $this->queryBuilder->select($this->module::idField());
        $total = $this->queryBuilder->query(true);
        $this->queryBuilder->limit($this->perPage,$this->offset);
        $this->queryBuilder->orderBy($this->orderBy);
        $rows = $this->queryBuilder->query();
        $count = count($rows);
        $pages = ceil($total/$this->perPage);
        $page = ceil($this->offset/$this->perPage)+1;

        $this->set("count",$count);
        $this->set("total",intval($total));
        $this->set("pages",$pages);
        $this->set("page",$page);

        $this->records = [];
        foreach($rows as $row) {
            $this->records[] = $this->module::getById($row[$this->module::idField()]);
        }
    }

    private function cleanColumns() {
        $allFields = $this->module::moduleFields();
        if(empty($this->fields)) {
            foreach($allFields as $fieldName=>$field) {
                if($field->listable()) {
                    $this->fields[$fieldName] = $field;
                }
            }
        }
        if(!empty($this->columns)) {
            foreach($this->fields as $fieldName=>$field) {
                if(!in_array($fieldName,$this->columns)) {
                    unset($this->fields[$fieldName]);
                }
            }
        }
    }

    private function parseSearch() {
        if(!empty($this->search)) {
            foreach($this->search as $condition) {
                $parsed = $this->parseCondition($condition);
                if($parsed === false) {
                    continue;
                }
                $this->queryBuilder->where($parsed["field"],$parsed["comparator"],$parsed["value"]);
            }
        }
    }

    private function parseCondition($condition) {
        $return = ["field"=>"","comparator"=>"eq","value"=>""];
        if(!is_array($condition)) {
            $condition = explode("::",$condition);
        }
        if(is_array($condition)) {
            if(isset($condition["field"]) && isset($condition["value"])) {
                $return["field"] = $condition["field"];
                $return["value"] = $condition["value"];
                if(isset($condition["comparator"])) {
                    $return["comparator"] = $condition["comparator"];
                }
                return $return;
            }
            if(count($condition) == 2) {
                $return["field"] = $condition[0];
                $return["value"] = $condition[1];
                return $return;
            }
            if(count($condition) == 3) {
                $return["field"] = $condition[0];
                $return["comparator"] = $condition[1];
                $return["value"] = $condition[2];
                return $return;
            }
            return false;
        }
        return false;
    }
}