<?php
namespace boru\dhfw\app\fw\commands;

use boru\dhcli\Option;
use boru\dhfw\base\BaseCommand;
use boru\dhfw\util\FWSetup;
use boru\dhutils\dhGlobal;

class InstallCommand extends BaseCommand {
    public static $commandDescription = "Install the base directory structure and a placeholder bootstrap library";

    public static function commandOptions() {
        return [
            Option::flag(  "f", "force" ,    "Force install"),
            Option::option("d", "directory", "Directory to install to",true,["default"=>"DEFAULT"]),
        ];
    }
    public function process() {
        $directory = $this->get("directory","DEFAULT");
        if($directory == "DEFAULT") {
            $directory = getcwd();
        }
        try {
            FWSetup::install($directory,$this->get("force",false));
        } catch (\Exception $e) {
            dhGlobal::outLine("Error installing framework:",$e->getMessage());
        }
    }
}