<?php
namespace boru\dhfw\app\fw\views;

class EditView extends ModalView {
    public $viewName = "Editmodal";

    protected $requiresAuth = true;

    /** @var \boru\dhfw\app\fw\Module */
    private $moduleRecord;
    public function init() {
        parent::init();
        $module = $this->module();
        $this->moduleRecord = $module::getById($this->recordId());
        if(!$this->moduleRecord) {
            throw new \Exception("No record found for id: ".$this->recordId());
        }
        $this->viewer->assign("record",$this->moduleRecord);
        $this->viewer->assign("inModal",true);
        $this->viewer->assign("moduleName",$this->module()->moduleName());
    }
    public function process() {
        $this->viewer->assign("recordLabel", $this->moduleRecord->label());
        $this->viewer->assign('recordId', $this->moduleRecord->id());
        $this->viewer->assign("fields",$this->moduleRecord->fields());
        $this->viewer->assign("functions",[]);

        $this->viewer->display("EditModal.tpl");
    }
}