<?php
namespace boru\dhfw\app\basemodule\fields;

use boru\dhfw\AppRouter;

class CompoundField extends Field {
    public function __construct($data=[]) {
        parent::__construct($data);
    }
    public function capture($appRouter,$prefix="") {
        $data = [];
        foreach($this->fields() as $field) {
            $field->capture($appRouter,$prefix);
            if(($map = $field->map()) !== false) {
                $data[$map] = $field->value();
            } else {
                $data[] = $field->value();
            }
        }
        $this->value(json_encode($data,JSON_UNESCAPED_SLASHES));
    }
}