<?php
namespace boru\dhfw\app\fw\apis;

class NotAuthorized extends Api {
    private $trace;
    private $exception;

    protected $requiresAuth = false;

    public function setException($exception) {
        $this->exception = $exception;
    }
    public function init() {
        
    }
    public function process() {
        if(!is_null($this->exception) && $this->exception instanceof \Exception) {
            $this->setData("message",$this->exception->getMessage());
            $this->setData("code",$this->exception->getCode() > 0 ? $this->exception->getCode() : 403);
        } else {
            $this->setData("message","Not Authorized");
            $this->setData("code",403);
        }
        
        $this->output($this->packetError($this->getData("message")));
    }
}