<?php
namespace boru\dhfw\util;

use boru\dhutils\dhGlobal;

class Container implements \JsonSerializable {
    protected $data = [];
    protected $rawData = [];

    protected $camelMap = [];
    protected $camelReverse = [];

    public function __construct($data=[]) {
        if(!empty($data)) {
            $this->setFromArray($data);
        }
    }

    public function has($dotKey) {
        $val = $this->get($dotKey,"_|xzx|_NOT_SET_|xzx|_");
        return $val !== "_|xzx|_NOT_SET_|xzx|_";
    }
    public function get($key=null,$defaultValue=null,$useMap=true) {
        if(is_null($key)) {
            return $this->toArray(false);
        }
        if(isset($this->data[$key])) {
            return $this->data[$key];
        }
        if($useMap && isset($this->camelReverse[$key])) {
            $key = $this->camelReverse[$key];
            if(isset($this->data[$key])) {
                return $this->data[$key];
            }
        }
        return $defaultValue;
    }
    public function set($key,$value=null,$useMap=true) {
        if(is_array($key)) {
            $this->data=$key;
            return $this;
        }
        if($useMap && isset($this->camelMap[$key])) {
            $key = $this->camelMap[$key];
            $this->data[$key] = $value;
            return $this;
        }
        $this->data[$key] = $value;
        $camelKey = $this->camelKey($key);
        $this->camelMap[$key] = $camelKey;
        $this->camelReverse[$camelKey] = $key;
        return $this;
    }
    public function getRaw($key=null,$defaultValue=null) {
        if(is_null($key)) {
            return $this->rawData;
        }
        return isset($this->rawData[$key]) ? $this->rawData[$key] : $defaultValue;
    }
    public function setRaw($key,$value=null) {
        if(is_array($key)) {
            $this->rawData=$key;
            return $this;
        }
        $this->rawData[$key] = $value;
        return $this;
    }

    public function toArray() {
        return $this->data;
    }

    public function __toString() {
        return json_encode($this->toArray(),JSON_PRETTY_PRINT);
    }
    public function jsonSerialize() {
        return $this->toArray();
    }
    public function setFromArray($array) {
        if(is_object($array) && method_exists($array,"toArray")) {
            $array = $array->toArray();
        }
        if(empty($array)) { return false; }
        $this->rawData = $array;
        foreach($array as $key=>$value) {
            //add it to our data set
            $this->set($key,$value,false);
        }
    }
    public function camelKey($key) {
        return dhGlobal::camelize($key);
    }
}