<?php
namespace boru\dhfw\util;

use boru\dhutils\tools\DebugTrace;
use boru\dhutils\tools\ExecTimer;

class Debug {
    /**
     * @var DebugEntry[]
     */

    private static $enabled = false;
    private static $print = true;
    private static $debugLevel = null;

    private static $isInit = false;
    public static function init($force=false) {
        if(self::$isInit && !$force) {
            return;
        }
        
    }
    public static function add($level=1,$notes = null) {
        static::init();
        if(!self::$enabled || !static::shouldPrint($level)) {
            return;
        }
        return ExecTimer::create();
    }
    public static function addNote($level=1,...$notes) {
        static::init();
        if(!self::$enabled || !static::shouldPrint($level)) {
            return;
        }
        return DebugTrace::create(implode(" ",$notes));
    }
    public static function enable($level=null) {
        self::$enabled = true;
        if(!is_null($level)) {
            self::$debugLevel = $level;
        }
        ExecTimer::enable();
        ExecTimer::traceSteps(3);
        DebugTrace::enable();
        DebugTrace::traceSteps(3);
        static::init();
    }
    public static function disable() {
        self::$enabled = false;
    }
    public static function setPrint($print) {
        self::$print = $print;
    }

    public static function shouldPrint($level=null) {
        if(!is_null(static::$debugLevel) && !is_null($level) && $level > self::$debugLevel) {
            return false;
        }
        return self::$print;
    }
}