<?php
namespace boru\dhfw\util;

use boru\dhfw\DHFW;
use boru\dhfw\util\FindDir;
use boru\dhfw\util\Config;
use boru\dhutils\dhGlobal;
use boru\dhutils\filesys\Directory;

class FWSetup {
    private static $rootDirectory = null;
    public static function install($directory=null,$force=false) {
        if(is_null($directory)) {
            $directory = FindDir::findRootDirectory();
        }
        if($directory === false) {
            throw new \Exception("Could not find root directory");
        }
        if(!is_dir($directory)) {
            throw new \Exception("Root directory is not a directory");
        }
        if(!is_writable($directory)) {
            throw new \Exception("Root directory is not writable");
        }
        if(!is_dir($directory."/vendor")) {
            throw new \Exception("Root directory does not contain a vendor directory");
        }
        if(!is_file($directory."/composer.json")) {
            throw new \Exception("Root directory does not contain a composer.json file");
        }

        static::copyFile($directory,"/init.php",$force);

        static::createDirectory($directory,"/app",$force);
        static::createDirectory($directory,"/public",$force);
        static::createDirectory($directory,"/scripts",$force);
        static::createDirectory($directory,"/storage",$force);
        static::createDirectory($directory,"/smarty",$force);
        static::copyDir($directory,"/public",$force);
        static::copyDir($directory,"/smarty",$force);
        //config.json setup
        static::checkConfig($directory."/config.json");
        static::initTables();
    }

    public static function createDirectory($directory,$item,$force=false) {
        $path = $directory.$item;
        if(!is_dir($path) || $force) {
            dhGlobal::outLine("+","Creating:",$item);
            Directory::fromPathString($path,true);
        } else {
            dhGlobal::outLine(" ","exists:  ",$item);
        }
    }
    public static function copyFile($directory,$item,$force=false) {
        $path = $directory.$item;
        $source = __DIR__."/../..".$item;
        if(!file_exists($path) || $force) {
            dhGlobal::outLine("+","Copying: ",$item);
            copy($source,$path);
        } else {
            dhGlobal::outLine(" ","exists:  ",$item);
        }
    }
    public static function copyDir($directory,$item,$force=false) {
        $path = $directory.$item;
        $source = __DIR__."/../..".$item;
        static::_copyRecursive($source,$path,$item,$force);
    }
    private static function _copyRecursive($src,$dst,$item,$force=false) {
        dhGlobal::outLine(" ","Recurs:  ",$item."/");
        $dir = opendir($src); 
        @mkdir($dst); 
        while( $file = readdir($dir) ) { 
            $srcPath = $src . '/' . $file;
            $dstPath = $dst . '/' . $file;
            $itemSub = $item."/".$file;
            if (( $file == '.' ) || ( $file == '..' )) { 
                continue; 
            }
            if ( is_dir($srcPath) ) { 
                static::_copyRecursive($srcPath, $dstPath,$itemSub,$force); 
            } 
            else { 
                if(file_exists($dstPath) && $force) {
                    unlink($dstPath);
                } elseif(file_exists($dstPath)) {
                    dhGlobal::outLine(" ","exists:   - ",$itemSub);
                    continue;
                }
                dhGlobal::outLine("+","Copying:  - ",$itemSub);
                copy($srcPath, $dstPath); 
            } 
        } 
        closedir($dir);
    }

    private static $defaultConfig = [
        "siteUrl"       => "",
        "siteName"      => "",
        "baseNamespace" => "\\FWAPP",
        "rootDirectory" => "",
        "db"=>[
            "dbtype"    => "mysql",
            "host"      => "",
            "user"      => "",
            "pass"      => "",
            "name"      => ""
        ],
        "resources"=> [
            "useDhfwJs" => true,
            "stylesheets"   => [
                ["href"=>"css/bootstrap/bootstrap.min.css","attributes"=>[]],
                ["href"=>"css/dataTables/datatables.min.css","attributes"=>[]],
                ["href"=>"css/fa/css/fontawesome.min.css","attributes"=>[]],
                ["href"=>"css/app.css","attributes"=>[]],
            ],
            "headerJavascripts"   => [
                ["src"=>"js/jquery-3.7.0.min.js","attributes"=>[]],
                ["src"=>"js/bootstrap/bootstrap.bundle.min.js","attributes"=>[]],
                ["src"=>"js/dataTables/datatables.min.js","attributes"=>[]],
            ],
            "footerJavascripts"   => [
            ],
        ],
        "session" => [
            "handler"=> "dhdb",
            "table" => "sessions",
            "expiry"=> 7200,
        ]
    ];
    public static function checkConfig($configFile) {
        $config = Config::fromFile($configFile);
        $updated=false;
        foreach(static::$defaultConfig as $key=>$value) {
            if(!$config->has($key)) {
                $config->set($key,$value);
                $updated=true;
            }
        }
        if($config->get("rootDirectory","") == "") {
            $config->set("rootDirectory",FindDir::findRootDirectory());
            $updated=true;
        }
        if($updated) {
            $config->save();
        }
        return $config;
    }


    public static function initTables() {
        $tables["dhfw_fields"] = "CREATE TABLE IF NOT EXISTS `dhfw_fields` (
            `id` bigint(19) NOT NULL AUTO_INCREMENT,
            `module` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
            `name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
            `label` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
            `type` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT 'text',
            `baseType` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT 'text',
            `required` tinyint(1) NOT NULL DEFAULT '0',
            `hidden` tinyint(1) NOT NULL DEFAULT '0',
            `editable` tinyint(1) NOT NULL DEFAULT '0',
            `listable` tinyint(1) NOT NULL DEFAULT '0',
            `listorder` int(19) NOT NULL DEFAULT '0',
            `detailorder` int(19) NOT NULL DEFAULT '0',
            `derivedCallable` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT 'none',
            `reference` json DEFAULT NULL,
            `options` json DEFAULT NULL,
            `subfields` json DEFAULT NULL,
            PRIMARY KEY (`id`),
            KEY `list_idx` (`hidden`,`listable`,`module`,`listorder`),
            KEY `detail_idx` (`hidden`,`module`,`detailorder`)
          ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci";
        foreach($tables as $tableSql) {
            $result = DHFW::db()->query($tableSql);
            if($result === false) {
                throw new \Exception("Could not create table");
            }
        }
    }
}