/**
 * DHFW App JS
 * version 1.0.0
 * Modified 2021-10-03
 * Author: Daniel Hayes
 */
jQuery(function() {
    $(".dataTables_wrapper .dataTables_length select").css("margin-right","30px")
    $('.use-select2').select2({
        theme: 'navdark'
    });
});
$(document).ready(function(){
    //DeleteButton actions
    $("body").on('click','.deleteRecord',function(){
        let recordId = $(this).data("recordid");
        let moduleLabel = $(this).data("module");
        if(typeof moduleLabel === 'undefined' || moduleLabel == null || moduleLabel == "") {
            moduleLabel = APPMODULE;
        }
        let moduleName = moduleLabel.toLowerCase();
        let redirect = $(this).data("redirect");
        if(typeof redirect === 'undefined' || redirect == null || redirect != false) {
            redirect = true;
        } else {
            redirect = false;
        }
        //if data-trigger-event is set, then trigger that event
        let triggerEvent = $(this).data("triggerEvent");
        let url = "/"+moduleName+"/"+recordId+"/a/delete";
        let data = {};

        var modal = AppModal.confirm("Deleting "+moduleLabel+" "+recordId,"Are you sure you want to delete this "+moduleLabel+"?",function(){
            AppConnector.post(url,{
                data: data,
                dataType: "json"
            }).then(
                function(response) {
                    if(redirect) {
                        window.location.href = response.data.url;
                    }
                    modal.hide();
                    if(typeof triggerEvent !== 'undefined' && triggerEvent != null && triggerEvent != "") {
                        $('body').trigger(triggerEvent);
                        return false;
                    }
                },
                function(response) {
                    console.log('responseError',response);
                    modal.find(".modalErrorMessage").html(response.message);
                    modal.find(".modalErrorMessageGroup").removeClass("d-none");
                }
            );
        });        
    });
    //CreateButton actions
    $("body").on('click','.createRecord, .editRecord',function(){
        let edit = false;
        let recordId = null;
        //if has class editRecord, then edit = true
        if($(this).hasClass('editRecord')) {
            edit = true;
            recordId = $(this).data("recordid");
        }

        var moduleLabel = $(this).data("module");
        if(typeof moduleLabel === 'undefined' || moduleLabel == null || moduleLabel == "") {
            moduleLabel = APPMODULE;
        }
        var moduleName = moduleLabel.toLowerCase();
        
        var redirect = $(this).data("redirect");
        if(typeof redirect === 'undefined' || redirect == null || redirect != false) {
            redirect = true;
        } else {
            redirect = false;
        }
        
        //if data-trigger-event is set, then trigger that event
        var triggerEvent = $(this).data("triggerEvent");
        
        var data = {};
        var prefill = getPrefillValues($(this));
        if(prefill == false) {
        } else {
            data.prefill = prefill.fields;
            data.hide = prefill.hide;
        }
        if(edit) {
            data.recordId = recordId;
            var modal = AppModal.view("/"+moduleName+"/"+recordId+"/edit/", "Edit "+moduleLabel+" "+recordId,null,data);
        } else {
            var modal = AppModal.view("/"+moduleName+"/create", "Add New "+moduleLabel,null,data);
        }
        modal.large();
        var cancel = modal.addButton("Cancel","btn btn-default",true);
        var button = modal.addButton("Save","btn btn-primary",false);
        button.closest("form").keypress(function(e) {
            if(e.which == 13) {
                button.click();
            }
        });
        button.on("click",function(){
            let canSubmit = true;
            modal.find(".modalErrorMessageGroup").addClass("d-none");
            modal.find(".modalErrorMessage").html("Unknown error occured. Please try again.");
            var data = {};
            modal.find('.createField:not([type="radio"]):not([type="checkbox"])').each(function(){
                var field = $(this).attr("name");
                var val = $(this).val();
                if(val == ""){
                    if($(this).attr("required") == "required" || $(this).data("required") == true) {
                        modal.find(".modalErrorMessage").html("Please fill all the fields");
                        modal.find(".modalErrorMessageGroup").removeClass("d-none");
                        canSubmit = false;
                    }
                }
                data[field] = val;
            });
            modal.find('.createField[type="radio"]:checked, .createField[type="checkbox"]:checked').each(function(){
                var field = $(this).attr("name");
                var val = $(this).val();
                data[field] = val;
            });
            modal.find('.createField[type="radio"], .createField[type="checkbox"]').each(function(){
                if(typeof data[$(this).attr("name")] === 'undefined') {
                    if($(this).attr("required") == "required" || $(this).data("required") == true) {
                        modal.find(".modalErrorMessage").html("Please fill all the fields");
                        modal.find(".modalErrorMessageGroup").removeClass("d-none");
                        canSubmit = false;
                    }
                }
            });
            if(canSubmit) {
                let url = "/"+moduleName+"/a/create";
                if(edit) {
                    url = "/"+moduleName+"/"+recordId+"/a/save";
                }
                AppConnector.post(url,{
                    data: data,
                    dataType: "json"
                }).then(
                    function(response) {
                        console.log('responseSuccess',response);
                        if(redirect) {
                            window.location.href = response.data.url;
                        }
                        
                        modal.hide();
                        if(typeof triggerEvent !== 'undefined' && triggerEvent != null && triggerEvent != "") {
                            $('body').trigger(triggerEvent);
                            return false;
                        }
                    },
                    function(response) {
                        console.log('responseError',response);
                        modal.find(".modalErrorMessage").html(response.message);
                        modal.find(".modalErrorMessageGroup").removeClass("d-none");
                    }
                );
            }
        });
    });
    //DetailView Edit Actions
    $("body").on('click','.detailValue.editable',function(){
        var thisObject = $(this);
        var field = $(this).data('field');
        var fieldType = $(this).data('type');
        var fieldOptions = $(this).data('options');
        if(typeof fieldType === 'undefined' || fieldType == null || fieldType == "") {
            fieldType = "text";
        }
        //if data-trigger-event is set, then trigger that event
        var triggerEvent = $(this).data("triggerEvent");
        
        var recordId = $('#recordId').val();
        var data = {
            field:field,
            fieldType:fieldType,
            fieldOptions:fieldOptions
        };
        $(this).on("click",function() {
            var modal = AppModal.view("/"+APPMODULE+"/"+recordId+"/fieldedit","Edit "+field,null,data);
            var cancel = modal.addButton("Cancel","btn btn-default",true);
            var button = modal.addButton("Save","btn btn-primary",false);
            button.on("click",function(){
                var data = {
                    recordId:recordId,
                    field:field,
                };
                modal.find(".editField").each(function(){
                    var field = $(this).attr("name");
                    var val = $(this).val();
                    if(val == ""){
                        if($(this).attr("required") == "required" || $(this).data("required") == true) {
                            modal.find(".modalErrorMessage").html("Please fill all the fields");
                            modal.find(".modalErrorMessageGroup").removeClass("d-none");
                            return false;
                        }
                    }
                    data[field] = val;
                });
                
                AppConnector.post("/"+APPMODULE+"/a/fieldedit",{
                    data: data,
                    dataType: "json"
                }).then(
                    function(response) {
                        console.log('responseSuccess',response);
                        if(response.success) {
                            thisObject.html(response.data.value);
                        }
                        modal.hide();
                        if(typeof triggerEvent !== 'undefined' && triggerEvent != null && triggerEvent != "") {
                            $('body').trigger(triggerEvent);
                            return false;
                        }
                    },
                    function(response) {
                        console.log('responseError',response);
                        modal.find(".modalErrorMessage").html(response.message);
                        modal.find(".modalErrorMessageGroup").removeClass("d-none");
                    }
                );
            });
        });
    });
    //logout link
    $("body").on('click','.logout-link',function(){
        AppModal.confirm("Confirm Logout","Are you sure you want to logout?",function(){
            AppConnector.post("/user/a/logout",{data: {},dataType: "json"}).then(function(response){
                window.location.href = APPURL + "/user/login";
            },function(response) {
                AppModal.alert("Error Logging Out","There was an error logging out. Please try again.");
            });
        });
    });
    $("body").on("dhfw:reload",function(){
        console.log('reloadListener');
        setTimeout(function(){
            let modal = AppModal.current();
            if(modal != false) {
                console.log('reloadListener:reload');
                modal.reload();
            }
        },500);
    });
    $(".listViewTable").each(function() {
        let table = $(this);
        let json = table.data("search");
        if(typeof json !== 'object') {
            json = JSON.parse(json);
            if(typeof json !== 'object') {
                return false;
            }
        }
        console.log(json);
        let module = json.module;
        let searchUrl = AppConnector.actionUrl(module.toLowerCase(),"search");
        let data = {
            search: json.searchString,
            columns: json.fields,
            perPage: json.perPage,
            page: json.page,
            orderBy: json.orderBy,
        }
        AppConnector.post(searchUrl,{data: data,dataType: "json"}).then(function(response){
            console.log(response);
            if(typeof response.success !== 'undefined' && response.success && typeof response.data !== 'undefined' && typeof response.data.records !== 'undefined') {
                tbody = table.find("tbody");
                tbody.html("");
                $.each(response.data.records,function(i,record){
                    let tr = $("<tr></tr>");
                    $.each(json.fields,function(i,field){
                        let td = $("<td></td>");
                        if(typeof record[field] !== 'undefined') {
                            td.html(record[field]);
                        }
                        tr.append(td);
                    });
                    tbody.append(tr);
                });
            }
        });
    });
});

function getPrefillValues(field) {
    var module = field.data('module');
    var prefillClass = field.data('prefillClass');
    var data = {};
    var hide = {};
    var has = false;
    if(typeof prefillClass !== 'undefined' && prefillClass != null && prefillClass != "") {
        $("."+prefillClass).each(function() {
            has = true;
            var field = $(this).data('field');
            var value = $(this).val();
            data[field] = value;
            var hideField = $(this).data('hide');
            if(typeof hideField !== 'undefined' && hideField != null && hideField != "") {
                hide[field] = true;
            }
        });
    } else {
        $(".createRecordPrefill").each(function() {
            if($(this).data('module') == module) {
                has = true;
                var field = $(this).data('field');
                var value = $(this).val();
                data[field] = value;
            }
        });
    }
    if(has) {
        return {
            fields:data,
            hide:hide
        };
    } else {
        return false;
    }
}
function backfillMapper(data,backfillClassName) {
    $("."+backfillClassName).each(function() {
        var field = $(this).data('field');
        if(typeof data[field] === 'undefined' || data[field] == null || data[field] == "") {
            value = "";
        } else {
            var value = data[field];
        }
        $(this).val(value);
    });
}