<?php
namespace boru\dhfw\app\basemodule\views;

class ListView extends View {
    public function init() {
        parent::init();
        $this->setTemplate("postHeader","SubHeader.tpl");
    }

    private $records = [];
    public function process() {
        $module = $this->module();

        $fields = $module::moduleFields();
        $listFields = [];
        $listRecords = [];
        foreach($fields as $fieldName=>$field) {
            if($field->listable()) {
                $listFields[$fieldName] = $field;
            }
        }
        if(is_array($this->records)) {
            foreach($this->records as $record) {
                $listRecord = [];       
                foreach($listFields as $fieldName=>$field) {
                    $listRecord[$fieldName] = clone $field;
                    $listRecord[$fieldName]->value($record->get($fieldName));
                }
                $listRecords[$record->id()] = $listRecord;
            }
        }
        $this->viewer->assign("labelField",$module::labelField());
        $this->viewer->assign("listFields",$listFields);
        $this->viewer->assign("listRecords",$listRecords);
        $this->viewer->assign("records",$this->records);
        $this->viewer->display("ListView.tpl");
    }
    public function preProcess() {
        $module = $this->module();

        $rest = $this->getVar("rest","");
        $parts = explode("/",$rest);
        $searchArr = [];
        if(!empty($parts)) {
            foreach($parts as $part) {
                $search = explode("::",$part);
                if(count($search) == 2) {
                    $searchArr[$search[0]] = $search[1];
                }
            }
        }
        $records = [];
        if(empty($searchArr)) {
            $records = $module::search();
        } else {
            $records = $module::search($searchArr);
        }
        $this->setRecords($records);
    }

    public function setRecords($records) {
        $this->records = $records;
    }
}