<?php
namespace boru\dhfw\app\fw\actions;

use boru\dhfw\DHFW;

class JsloaderAction extends Action {
    protected $displayHeader = false;
    protected $displayFooter = false;
    protected $requiresAuth = false;

    private $moduleRecord;

    public function preProcess() {
        header("Content-type:text/javascript");
    }
    public function init() {
        $this->displayHeader = false;
        $this->displayFooter = false;
    }
    public function process() {
        $relFilePath = $this->getVar("rest","");
        if($relFilePath == "") {
            return;
        }
        $files = [];
        if($relFilePath = "all") {
            $files[] = "app/app.js";
            $files[] = "app/connector.js";
            $files[] = "app/modal.js";
        } elseif($relFilePath == "modal") {
            $files[] = "app/modal.js";
            $files[] = "app/CreateEditModal.js";
            $files[] = "app/DHFWEvents.js";
        } elseif($relFilePath == "connector") {
            $files[] = "app/connector.js";
        } elseif($relFilePath == "app") {
            $files[] = "app/app.js";
        } else {
            $files[] = $relFilePath;
        }
        foreach($files as $file) {
            echo "\n\n/* $file */\n\n";
            $this->loadFile($file);
        }
    }

    private function loadFile($relFilePath) {
        $dhfwVendorPub = dirname(__FILE__)."/../../../../public/js/";
        $appPub = DHFW::dir("public/js/");
        if(file_exists($dhfwVendorPub.$relFilePath)) {
            echo file_get_contents($dhfwVendorPub.$relFilePath);
            return;
        }
        if(file_exists($appPub.$relFilePath)) {
            echo file_get_contents($appPub.$relFilePath);
            return;
        }
        echo "";
        return;
    }
}