<?php
namespace boru\dhfw\app\fw\commands;

use boru\dhcli\Option;
use boru\dhfw\AppRouter;
use boru\dhfw\base\BaseCommand;
use boru\dhutils\dhGlobal;

class ListCommand extends BaseCommand {
    public static $commandDescription = "Lists available commands";
    
    public static function commandOptions() {
        return [
            Option::option("m", "module", "List commands for a specific module",false),
        ];
    }

    private $commands = [];
    private $longestFirstColumn = 0;

    public function preProcess() {
        parent::preProcess();
        $module = $this->get("module",false);
        $modules = AppRouter::listModules("all");
        if($module !== false) {
            $limitModules = explode(",",$module);
            $modules = array_intersect_key($modules,array_flip($limitModules));
        }
        $this->commands = [];
        $this->longestFirstColumn = 0;
        foreach($modules as $moduleName=>$className) {
            $moduleCommands = AppRouter::listModuleTypes($moduleName,"command");
            if(!empty($moduleCommands)) {
                $this->addRow([$moduleName]);
            
                foreach($moduleCommands as $commandName=>$commandClass) {
                    $commandName = strtolower($commandName);
                    $suffix = "command";
                    if(substr($commandName,-strlen($suffix)) == $suffix) {
                        $commandName = substr($commandName,0,-strlen($suffix));
                    }
                    if($moduleName != "basemodule") {
                        $commandName = $moduleName."/".$commandName;
                    }
                    $this->addRow(["  ".$commandName,$commandClass::$commandDescription]);
                }
            }
        }
    }
    public function process() {
        $this->printHeader();
        $this->printTable();
        $this->printSyntax();
    }
    public function getCommands() {
        return $this->commands;
    }

    public function getFirstLen($additional=0) {
        return $this->longestFirstColumn+$additional;
    }
    public function listAsTable() {
        foreach($this->getCommands() as $moduleName=>$moduleCommands) {
            $this->addRow([$moduleName]);
            foreach($moduleCommands as $commandName=>$commandClass) {
                $this->addRow(["  ".$commandName,$commandClass::$commandDescription]);
            }
        }
        $this->printTable();
    }
    public function printHeader() {
        dhGlobal::outLine($this->makeBarLine(" "));
        dhGlobal::outLine("Available commands:");
        dhGlobal::outLine();
    }
    public function printSyntax() {
        dhGlobal::outLine($this->makeBarLine(" "));
        dhGlobal::outLine();
        dhGlobal::outLine("'basemodule' commands do not require a module prefix");
        dhGlobal::outLine();
        dhGlobal::outLine("Syntax is <module>/<command>");
        dhGlobal::outLine("Use: help <module>/<command> for more information on a specific command");
        dhGlobal::outLine();
    }

    public function makeFirstColumn($text,$additional=0) {
        return dhGlobal::padRight($text,$this->getFirstLen($additional)," ");
    }
}