<?php
namespace boru\dhfw\util;

use boru\dhfw\util\query\ConditionGroup;

class QueryConditions extends ConditionGroup {
    private $qFields = [];
    private $qVals;
    private $glueType = "AND"; // "AND" or "OR"

    public function __construct() {
        $this->qFields = [];
        $this->qVals = [];
    }

    public function addArray($fields,$comparator="eq") {
        foreach($fields as $field=>$value) {
            $this->add($field,$value,$comparator);
        }
    }
    public function add($field,$value,$comparator="eq") {
        if($comparator == "=" || $comparator == "eq") {
			$this->qFields[] = "`$field`=?";
		} elseif($comparator == "!=" || $comparator == "neq") {
			$this->qFields[] = "`$field`!=?";
		} elseif($comparator == ">" || $comparator == "gt") {
			$this->qFields[] = "`$field`>?";
		} elseif($comparator == ">=" || $comparator == "gte") {
			$this->qFields[] = "`$field`>=?";
		} elseif($comparator == "<" || $comparator == "lt") {
			$this->qFields[] = "`$field`<?";
		} elseif($comparator == "<=" || $comparator == "lte") {
			$this->qFields[] = "`$field`<=?";
		} elseif($comparator == "s%" || $comparator == "starts_with") {
			$this->qFields[] = "`$field` LIKE ?";
			$value.="%";
		}
		$this->qVals[] = $value;
    }

    public function getSQL($prefix="WHERE 1 AND ") {
        $sql = $prefix;
        $sql.="( ";
        $sql.=implode(" ".$this->glueType." ",$this->qFields);
        $sql.=" )";
        return $sql;
    }
    public function getFields() {
        return $this->qFields;
    }
    public function getValues() {
        return $this->qVals;
    }
}